/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.extension.IJarFile;
import com.wily.util.io.IConstructorExternalizable;
import com.wily.util.io.NonSyncBufferedInputStream;
import com.wily.util.io.StreamCopier;
import com.wily.wilyassert.Assertion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class InMemoryJarFile
implements IConstructorExternalizable,
IJarFile {
    private String fName;
    private Attributes fAttributes;
    private Map fManifest = new HashMap();
    private Map fContents = new HashMap();

    public InMemoryJarFile(ObjectInput in) throws ClassNotFoundException, IOException {
        this.fName = in.readUTF();
        this.fManifest = (HashMap)in.readObject();
        this.fContents = (HashMap)in.readObject();
        this.fAttributes = this.readAttributes(in);
    }

    public InMemoryJarFile(JarInputStream in) throws ClassNotFoundException, IOException {
        this.fName = "LibraryJar" + System.identityHashCode(in);
        this.fManifest = in.getManifest().getEntries();
        this.fAttributes = in.getManifest().getMainAttributes();
        this.fContents = new HashMap();
        this.readContents(in);
    }

    public InMemoryJarFile(JarFile file) throws IOException {
        this.fName = file.getName();
        Manifest manifest = file.getManifest();
        this.fAttributes = manifest.getMainAttributes();
        this.fManifest.putAll(manifest.getEntries());
        Enumeration<JarEntry> i = file.entries();
        while (i.hasMoreElements()) {
            JarEntry entry = i.nextElement();
            String name = entry.getName();
            NonSyncBufferedInputStream input = new NonSyncBufferedInputStream(file.getInputStream(entry));
            byte[] data = input.readAvailable();
            input.close();
            this.fContents.put(name, data);
            Assertion.wilyAssert((long)data.length == entry.getSize());
        }
    }

    @Override
    public InputStream getInputStream(String entryName) throws IOException {
        byte[] fileBytes = this.getBytesForFile(entryName);
        if (fileBytes == null) {
            throw new IOException("Unknown entry " + entryName);
        }
        return new ByteArrayInputStream(fileBytes);
    }

    public Map getManifestMap() {
        return this.fManifest;
    }

    public byte[] getBytesForFile(String resource) {
        return (byte[])this.fContents.get(resource);
    }

    public void removeBytesForFile(String resource) {
        this.fContents.remove(resource);
    }

    public void appendJarFile(JarInputStream in) throws IOException {
        this.fManifest.putAll(in.getManifest().getEntries());
        this.fAttributes.putAll((Map<?, ?>)in.getManifest().getMainAttributes());
        this.readContents(in);
    }

    private void readContents(JarInputStream in) throws IOException {
        JarEntry entry;
        while ((entry = in.getNextJarEntry()) != null) {
            String name = entry.getName();
            if (entry.isDirectory()) continue;
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            StreamCopier.copy(in, oStream);
            this.fContents.put(name, oStream.toByteArray());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.fName);
        out.writeObject(this.fManifest);
        out.writeObject(this.fContents);
        this.writeAttributes(out, this.fAttributes);
    }

    @Override
    public Attributes getMainAttributes() {
        return this.fAttributes;
    }

    public String getName() {
        return this.fName;
    }

    private Attributes readAttributes(ObjectInput in) throws IOException {
        Attributes values = new Attributes();
        int num = in.readInt();
        int i = 0;
        while (i < num) {
            String name = in.readUTF();
            String value = in.readUTF();
            values.putValue(name, value);
            ++i;
        }
        return values;
    }

    private void writeAttributes(ObjectOutput out, Attributes attributes) throws IOException {
        Set<Map.Entry<Object, Object>> entrySet = attributes.entrySet();
        out.writeInt(entrySet.size());
        for (Map.Entry<Object, Object> entry : entrySet) {
            Attributes.Name name = (Attributes.Name)entry.getKey();
            String value = (String)entry.getValue();
            out.writeUTF(name.toString());
            out.writeUTF(value);
        }
    }
}

