/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

public final class FastArrayCopy {
    public static final void copy(byte[] source, int sourceOffset, byte[] dest, int destOffset, int len) {
        FastArrayCopy.copy16(source, sourceOffset, dest, destOffset, len);
    }

    private static final void copy16(byte[] source, int sourceOffset, byte[] dest, int destOffset, int len) {
        if (len <= 16) {
            switch (len) {
                case 16: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 15: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 14: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 13: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 12: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 11: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 10: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 9: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 8: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 7: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 6: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 5: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 4: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 3: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 2: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 1: {
                    dest[destOffset++] = source[sourceOffset++];
                }
            }
        } else {
            System.arraycopy(source, sourceOffset, dest, destOffset, len);
        }
    }

    private static final void copy8(byte[] source, int sourceOffset, byte[] dest, int destOffset, int len) {
        if (len <= 8) {
            switch (len) {
                case 8: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 7: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 6: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 5: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 4: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 3: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 2: {
                    dest[destOffset++] = source[sourceOffset++];
                }
                case 1: {
                    dest[destOffset++] = source[sourceOffset++];
                }
            }
        } else {
            System.arraycopy(source, sourceOffset, dest, destOffset, len);
        }
    }

    private static final void copyLoop(byte[] source, int sourceOffset, byte[] dest, int destOffset, int len) {
        while (len-- > 0) {
            dest[destOffset++] = source[sourceOffset++];
        }
    }

    private static void test(int size) {
        byte[] buffer = new byte[size];
        byte[] buffer2 = new byte[size];
        long startTime = System.currentTimeMillis();
        int i = 0;
        while (i < 2000000) {
            FastArrayCopy.copy(buffer, 0, buffer2, 0, size);
            ++i;
        }
        long time = System.currentTimeMillis() - startTime;
        System.out.println("Copy of Size: " + size + ", Time(ms): " + time);
        startTime = System.currentTimeMillis();
        i = 0;
        while (i < 2000000) {
            FastArrayCopy.copy8(buffer, 0, buffer2, 0, size);
            ++i;
        }
        time = System.currentTimeMillis() - startTime;
        System.out.println("Copy8 of Size: " + size + ", Time(ms): " + time);
        startTime = System.currentTimeMillis();
        i = 0;
        while (i < 2000000) {
            FastArrayCopy.copy16(buffer, 0, buffer2, 0, size);
            ++i;
        }
        time = System.currentTimeMillis() - startTime;
        System.out.println("Copy16 of Size: " + size + ", Time(ms): " + time);
        startTime = System.currentTimeMillis();
        i = 0;
        while (i < 2000000) {
            System.arraycopy(buffer, 0, buffer2, 0, size);
            ++i;
        }
        time = System.currentTimeMillis() - startTime;
        System.out.println("System.arraycopy of Size: " + size + ", Time(ms): " + time);
        startTime = System.currentTimeMillis();
        i = 0;
        while (i < 2000000) {
            FastArrayCopy.copyLoop(buffer, 0, buffer2, 0, size);
            ++i;
        }
        time = System.currentTimeMillis() - startTime;
        System.out.println("Loop of Size: " + size + ", Time(ms): " + time);
        System.out.println();
    }

    public static void main(String[] args) {
        FastArrayCopy.test(1);
        FastArrayCopy.test(4);
        FastArrayCopy.test(8);
        FastArrayCopy.test(16);
        FastArrayCopy.test(32);
        FastArrayCopy.test(2048);
    }
}

