/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.locale;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class LocaleUtils {
    private static final Locale BASE_FALLBACK_LOCALE = Locale.ENGLISH;
    private static final String FALLBACK_LOCALE_KEY = "_FALLBACK_LOCALE_";

    public static Locale stringToLocale(String localeStr) {
        String[] tokens = localeStr.split("-");
        if (tokens.length < 1) {
            return null;
        }
        String iso3Lang = tokens[0];
        String iso3Country = "";
        if (tokens.length > 1) {
            iso3Country = tokens[1];
        }
        return new Locale(iso3Lang, iso3Country);
    }

    public static String localeToString(Locale locale) {
        String localeStr = locale.getLanguage();
        if (locale.getCountry().length() > 0) {
            localeStr = String.valueOf(localeStr) + "-" + locale.getCountry();
        }
        return localeStr;
    }

    public static String bestAvailableLocale(Set localeStrings, Locale reqLocale) {
        if (reqLocale == null) {
            return null;
        }
        String localeStr = LocaleUtils.localeToString(reqLocale);
        if (localeStrings.contains(localeStr)) {
            return localeStr;
        }
        localeStr = reqLocale.getLanguage();
        if (localeStrings.contains(localeStr)) {
            return localeStr;
        }
        if (LocaleUtils.isBaseLocale(localeStr)) {
            return null;
        }
        Locale defaultLocale = Locale.getDefault();
        localeStr = LocaleUtils.localeToString(defaultLocale);
        if (localeStrings.contains(localeStr)) {
            return localeStr;
        }
        localeStr = defaultLocale.getLanguage();
        if (localeStrings.contains(localeStr)) {
            return localeStr;
        }
        return null;
    }

    public static boolean haveLocalizedResource(Locale locale, String resource, ClassLoader loader) {
        if (locale == null || loader == null) {
            return false;
        }
        ResourceBundle bundle = ResourceBundle.getBundle(resource, locale, loader);
        if (bundle == null) {
            return false;
        }
        return bundle.getLocale().getLanguage().equals(locale.getLanguage());
    }

    public static boolean isBaseLocale(String locale) {
        return locale.equalsIgnoreCase(BASE_FALLBACK_LOCALE.getLanguage());
    }

    public static Locale getFallbackLocale() {
        return BASE_FALLBACK_LOCALE;
    }

    public static Map<String, Locale> parseSupportedLocales(String supportedLocales) {
        HashMap<String, Locale> result = new HashMap<String, Locale>();
        boolean first = true;
        String[] stringArray = supportedLocales.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale;
            String mapLoc = stringArray[n2];
            int colonIdx = mapLoc.indexOf(58);
            if (colonIdx < 0) {
                locale = LocaleUtils.stringToLocale(mapLoc);
                result.put(mapLoc.toLowerCase(), locale);
            } else {
                locale = LocaleUtils.stringToLocale(mapLoc.substring(colonIdx + 1));
                result.put(mapLoc.substring(0, colonIdx).toLowerCase(), locale);
            }
            if (first) {
                result.put(FALLBACK_LOCALE_KEY, locale);
                first = false;
            }
            ++n2;
        }
        return result;
    }

    public static Locale bestSupportedLocale(Map<String, Locale> locales, Enumeration<Locale> reqLocales) {
        if (locales != null) {
            while (reqLocales.hasMoreElements()) {
                Locale locale = reqLocales.nextElement();
                Locale result = locales.get(LocaleUtils.localeToString(locale).toLowerCase());
                if (result != null) {
                    return result;
                }
                String country = locale.getCountry();
                if (country == null || country.isEmpty()) continue;
                Locale localeLanCou = new Locale(locale.getLanguage(), country);
                result = locales.get(LocaleUtils.localeToString(localeLanCou).toLowerCase());
                if (result != null) {
                    return result;
                }
                int slashIdx = country.indexOf(45);
                if (slashIdx == -1) continue;
                localeLanCou = new Locale(locale.getLanguage(), country.substring(slashIdx + 1));
                result = locales.get(LocaleUtils.localeToString(localeLanCou).toLowerCase());
                if (result != null) {
                    return result;
                }
                localeLanCou = new Locale(locale.getLanguage(), country.substring(0, slashIdx));
                result = locales.get(LocaleUtils.localeToString(localeLanCou).toLowerCase());
                if (result == null) continue;
                return result;
            }
            Locale fallbackLocale = locales.get(FALLBACK_LOCALE_KEY);
            return fallbackLocale == null ? BASE_FALLBACK_LOCALE : fallbackLocale;
        }
        return BASE_FALLBACK_LOCALE;
    }
}

