/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties.lockable;

import com.wily.util.StringUtils;
import com.wily.util.properties.lockable.CommentLine;
import com.wily.util.properties.lockable.KeyLine;
import com.wily.util.properties.lockable.ProfileLine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Profile {
    private final List<ProfileLine> fLines = new ArrayList<ProfileLine>();
    private final Map<String, KeyLine> fActiveKeys = new HashMap<String, KeyLine>();
    private final Map<String, List<KeyLine>> fInactiveKeys = new HashMap<String, List<KeyLine>>();

    public List<ProfileLine> getLines() {
        return Collections.unmodifiableList(this.fLines);
    }

    public Collection<KeyLine> getActiveKeys() {
        ArrayList<KeyLine> intermediate = new ArrayList<KeyLine>(this.fActiveKeys.values());
        return Collections.unmodifiableList(intermediate);
    }

    public Set<String> getInactiveKeyNames() {
        return Collections.unmodifiableSet(this.fInactiveKeys.keySet());
    }

    public List<KeyLine> getInactiveKeyValue(String key) {
        if (this.fInactiveKeys.containsKey(key)) {
            return this.fInactiveKeys.get(key);
        }
        return new ArrayList<KeyLine>();
    }

    private static boolean isComment(char ch) {
        return ch == '#' || ch == '!';
    }

    private static boolean isKeyValueSeparator(char ch, boolean inComment) {
        if (inComment) {
            return ch == '=' || ch == ':';
        }
        return ch == '=' || ch == ':' || Character.isWhitespace(ch);
    }

    public static Profile read(BufferedReader reader) throws IOException {
        Profile profile = new Profile();
        String line = null;
        int mode = 0;
        int count = 0;
        StringBuilder accumulator = new StringBuilder();
        String key = null;
        boolean escaped = false;
        while ((line = reader.readLine()) != null) {
            ++count;
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty()) {
                CommentLine cl = new CommentLine(count, line);
                profile.fLines.add(cl);
                continue;
            }
            int i = 0;
            while (i < trimmedLine.length()) {
                char c = trimmedLine.charAt(i);
                if (mode == 0) {
                    if (!Character.isWhitespace(c)) {
                        if (Profile.isComment(c)) {
                            mode = 1;
                        } else {
                            accumulator.append(c);
                            mode = 2;
                        }
                    }
                } else if (mode == 1) {
                    if (Character.isLetterOrDigit(c)) {
                        accumulator.append(c);
                        mode = 3;
                    } else if (!Character.isWhitespace(c)) {
                        mode = 4;
                        break;
                    }
                } else if (mode == 2) {
                    if (c == '\\' && !escaped) {
                        escaped = true;
                    } else if (escaped) {
                        accumulator.append(c);
                        escaped = false;
                    } else if (Profile.isKeyValueSeparator(c, false) && key == null) {
                        key = accumulator.toString().trim();
                        accumulator.setLength(0);
                    } else {
                        accumulator.append(c);
                    }
                } else if (mode == 3) {
                    if (c == '\\' && !escaped) {
                        escaped = true;
                    } else if (escaped) {
                        accumulator.append(c);
                        escaped = false;
                    } else if (Profile.isKeyValueSeparator(c, true) && key == null) {
                        key = accumulator.toString().trim();
                        accumulator.setLength(0);
                    } else {
                        accumulator.append(c);
                    }
                }
                ++i;
            }
            switch (mode) {
                case 2: {
                    KeyLine kl;
                    if (escaped) break;
                    if (key == null) {
                        key = accumulator.toString().trim();
                        kl = new KeyLine(count, key, false);
                    } else {
                        String value = accumulator.toString().trim();
                        if (value.isEmpty()) {
                            kl = new KeyLine(count, key, false);
                        } else {
                            if (value.charAt(0) == '=' || value.charAt(0) == ':') {
                                value = value.substring(1).trim();
                            }
                            kl = new KeyLine(count, key, false, value);
                        }
                    }
                    profile.fLines.add(kl);
                    profile.fActiveKeys.put(kl.getKey(), kl);
                    mode = 0;
                    key = null;
                    accumulator.setLength(0);
                    break;
                }
                case 3: {
                    CommentLine cl;
                    if (key != null) {
                        List<Object> keyLines;
                        String value = accumulator.toString().trim();
                        KeyLine kl = value.isEmpty() ? new KeyLine(count, key, true) : new KeyLine(count, key, true, value);
                        profile.fLines.add(kl);
                        if (profile.fInactiveKeys.containsKey(kl.getKey())) {
                            keyLines = profile.fInactiveKeys.get(kl.getKey());
                            if (keyLines == null) {
                                keyLines = new ArrayList();
                            }
                            keyLines.add(kl);
                        } else {
                            keyLines = new ArrayList<KeyLine>();
                            keyLines.add(kl);
                            profile.fInactiveKeys.put(kl.getKey(), keyLines);
                        }
                    } else {
                        cl = new CommentLine(count, line);
                        profile.fLines.add(cl);
                    }
                    mode = 0;
                    key = null;
                    accumulator.setLength(0);
                    escaped = false;
                    break;
                }
                case 1: 
                case 4: {
                    CommentLine cl = new CommentLine(count, line);
                    profile.fLines.add(cl);
                    mode = 0;
                    key = null;
                    accumulator.setLength(0);
                    escaped = false;
                }
            }
        }
        return profile;
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.getProfile());
        writer.flush();
    }

    private KeyLine findKeyLineByValue(List<KeyLine> keyLines, String value) {
        for (KeyLine kl : keyLines) {
            if (!StringUtils.nullHandlingEquals(value, kl.getValue())) continue;
            return kl;
        }
        return null;
    }

    public void update(Map<String, ?> props) {
        for (String s : props.keySet()) {
            KeyLine kl;
            String keyString = s.trim();
            String newValueString = null;
            if (props.get(keyString) != null) {
                newValueString = props.get(keyString).toString();
            }
            if (this.fActiveKeys.containsKey(keyString)) {
                kl = this.fActiveKeys.get(keyString);
                if (StringUtils.nullHandlingEquals(newValueString, kl.getValue())) continue;
                List<KeyLine> keyLines = this.fInactiveKeys.get(keyString);
                if (keyLines != null && !keyLines.isEmpty()) {
                    KeyLine ikl = this.findKeyLineByValue(keyLines, newValueString);
                    if (ikl != null) {
                        keyLines.remove(ikl);
                        ikl.setCommented(false);
                        KeyLine previous = this.fActiveKeys.put(keyString, ikl);
                        if (previous == null) continue;
                        previous.setCommented(true);
                        keyLines.add(previous);
                        continue;
                    }
                    kl.setValue(newValueString);
                    continue;
                }
                kl.setValue(newValueString);
                continue;
            }
            if (this.fInactiveKeys.containsKey(keyString)) {
                List<KeyLine> keyLines = this.fInactiveKeys.get(keyString);
                if (keyLines == null || keyLines.isEmpty()) continue;
                KeyLine kl2 = this.findKeyLineByValue(keyLines, newValueString);
                if (kl2 == null) {
                    kl2 = keyLines.get(0);
                }
                keyLines.remove(kl2);
                kl2.setCommented(false);
                KeyLine previous = this.fActiveKeys.put(keyString, kl2);
                if (previous == null) continue;
                previous.setCommented(true);
                keyLines.add(previous);
                continue;
            }
            kl = new KeyLine(this.fLines.size() + 1, keyString, false, newValueString);
            this.fLines.add(kl);
            this.fActiveKeys.put(keyString, kl);
        }
    }

    public void clear() {
        this.fLines.clear();
        for (List<KeyLine> keyLines : this.fInactiveKeys.values()) {
            keyLines.clear();
        }
        this.fInactiveKeys.clear();
        this.fActiveKeys.clear();
    }

    public String toString() {
        return "Class: Profile\n" + this.getProfile();
    }

    private String getProfile() {
        StringBuilder strBldr = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        for (ProfileLine line : this.fLines) {
            strBldr.append(line.getLine()).append(newLine);
        }
        return strBldr.toString();
    }

    public String getActiveKeyValue(String key) {
        KeyLine kl = this.fActiveKeys.get(key);
        if (kl != null) {
            return kl.getValue();
        }
        return null;
    }
}

