/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.metric.calculator;

import com.wily.introscope.agent.metric.calculator.BinaryOperation;
import com.wily.introscope.agent.metric.calculator.Operation;
import com.wily.introscope.spec.metric.TypeInquisitor;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.timeslice.ANumericalTimeslicedValue;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;

public class PercentageOperation
extends BinaryOperation {
    public PercentageOperation(Operation op1, Operation op2) {
        super(op1, op2);
    }

    @Override
    protected IMetricDataValue calculate(IMetricDataValue v1, IMetricDataValue v2) {
        ANumericalTimeslicedValue result = null;
        if (v1 instanceof ANumericalTimeslicedValue && v2 instanceof ANumericalTimeslicedValue) {
            result = this.percentageNumericalTimeslicedValues((ANumericalTimeslicedValue)v1, (ANumericalTimeslicedValue)v2);
        }
        return result;
    }

    private ANumericalTimeslicedValue percentageNumericalTimeslicedValues(ANumericalTimeslicedValue v1, ANumericalTimeslicedValue v2) {
        LongTimeslicedValue result = null;
        int type = !TypeInquisitor.isConstant((int)v1.getType()) ? v1.getType() : v2.getType();
        long startTimestamp = v1.getStartTimestampInMillis() > 0L ? v1.getStartTimestampInMillis() : v2.getStartTimestampInMillis();
        long stopTimestamp = v1.getStopTimestampInMillis() > 0L ? v1.getStopTimestampInMillis() : v2.getStopTimestampInMillis();
        BlameStackSnapshot blameStack = v1.getBlameStackSnapshot() != null ? v1.getBlameStackSnapshot() : v2.getBlameStackSnapshot();
        boolean dataIsAbsent = v1.dataIsAbsent() && v2.dataIsAbsent();
        long dataPointCount = v1.getDataPointCount() + v2.getDataPointCount();
        if (v1 instanceof LongTimeslicedValue || v2 instanceof LongTimeslicedValue) {
            long value = v2.getValueAsLong() != 0L ? v1.getValueAsLong() * 100L / v2.getValueAsLong() : 0L;
            long minimum = v2.getMinimumAsLong() != 0L ? v1.getMinimumAsLong() * 100L / v2.getMinimumAsLong() : 0L;
            long maximum = v2.getMaximumAsLong() != 0L ? v1.getMaximumAsLong() * 100L / v2.getMaximumAsLong() : 0L;
            dataPointCount = this.fixDataPointCount(type, dataPointCount, value);
            result = new LongTimeslicedValue(type, startTimestamp, stopTimestamp, blameStack, dataPointCount, dataIsAbsent, value, minimum, maximum);
        } else {
            int value = v2.getValueAsLong() != 0L ? (int)(v1.getValueAsLong() * 100L) / (int)v2.getValueAsLong() : 0;
            int minimum = v2.getMinimumAsLong() != 0L ? (int)(v1.getMinimumAsLong() * 100L) / (int)v2.getMinimumAsLong() : 0;
            int maximum = v2.getMaximumAsLong() != 0L ? (int)(v1.getMaximumAsLong() * 100L) / (int)v2.getMaximumAsLong() : 0;
            dataPointCount = this.fixDataPointCount(type, dataPointCount, value);
            result = new IntegerTimeslicedValue(type, startTimestamp, stopTimestamp, blameStack, dataPointCount, dataIsAbsent, value, minimum, maximum);
        }
        return result;
    }
}

