/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class CommonEncryptionProvider {
    protected boolean encryptionEnabled = true;
    private static final String SECRET_KEY = "PBEWithMD5AndDES";
    private static char[] alphabet;
    private static byte[] codes;

    public CommonEncryptionProvider() {
        try {
            SecretKeyFactory.getInstance(SECRET_KEY);
        }
        catch (Exception exe) {
            this.encryptionEnabled = false;
        }
    }

    public String encrypt(String str) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        if (!this.encryptionEnabled) {
            return str;
        }
        byte[] s1 = this.encryptLevel1(str.getBytes());
        char[] charArray = this.encode(s1);
        return new String(charArray);
    }

    public String decrypt(String str) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, BadPaddingException {
        if (!this.encryptionEnabled) {
            return str;
        }
        try {
            byte[] bytes = new byte[]{};
            try {
                bytes = this.decode(str.toCharArray());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            byte[] s1 = this.decryptLevel1(bytes);
            return new String(s1);
        }
        catch (IllegalBlockSizeException ibse) {
            return str;
        }
    }

    protected byte[] encryptLevel1(byte[] str) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return this.runPBECipher(true, str);
    }

    protected byte[] decryptLevel1(byte[] str) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return this.runPBECipher(false, str);
    }

    protected byte[] runPBECipher(boolean encrypt, byte[] str) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] salt = "CAUNCNTR".getBytes();
        int count = 20;
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec pbeKeySpec = new PBEKeySpec("umj2ee".toCharArray());
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance(SECRET_KEY);
        SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
        Cipher pbeCipher = Cipher.getInstance(SECRET_KEY);
        if (encrypt) {
            pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
        } else {
            pbeCipher.init(2, (Key)pbeKey, pbeParamSpec);
        }
        return pbeCipher.doFinal(str);
    }

    protected char[] encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    protected byte[] decode(char[] data) throws Exception {
        int tempLen = data.length;
        for (int ix = 0; ix < data.length; ++ix) {
            if (data[ix] <= '\u00ff' && codes[data[ix]] >= 0) continue;
            --tempLen;
        }
        int len = tempLen / 4 * 3;
        if (tempLen % 4 == 3) {
            len += 2;
        }
        if (tempLen % 4 == 2) {
            ++len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        for (int ix = 0; ix < data.length; ++ix) {
            int value;
            int n = value = data[ix] > '\u00ff' ? -1 : codes[data[ix]];
            if (value < 0) continue;
            accum <<= 6;
            accum |= value;
            if ((shift += 6) < 8) continue;
            out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
        }
        if (index != out.length) {
            throw new Exception("Miscalculated data length (wrote " + index + " instead of " + out.length + ")");
        }
        return out;
    }

    public String getDecryptedPassword(String password) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, BadPaddingException {
        if (password.startsWith("ENC(")) {
            password = this.decrypt(password.substring(4));
        }
        return password;
    }

    static {
        int i;
        alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        codes = new byte[256];
        for (i = 0; i < 256; ++i) {
            CommonEncryptionProvider.codes[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            CommonEncryptionProvider.codes[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            CommonEncryptionProvider.codes[i] = (byte)(26 + i - 97);
        }
        for (i = 48; i <= 57; ++i) {
            CommonEncryptionProvider.codes[i] = (byte)(52 + i - 48);
        }
        CommonEncryptionProvider.codes[43] = 62;
        CommonEncryptionProvider.codes[47] = 63;
    }
}

