/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent;

import com.wily.introscope.epagent.CommonEncryptionProvider;
import com.wily.introscope.epagent.FileHelper;
import com.wily.util.properties.IndexedProperties;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class EncryptionHelper {
    private static final Pattern keystorepasswordRelacementPattern = Pattern.compile("(\\bepagent.config.ssl.keystorepassword=)(.*)");
    private static final Pattern keyManagerpasswordRelacementPattern = Pattern.compile("(\\bepagent.config.ssl.keymanagerpassword=)(.*)");
    public static final String APM_ENCRYPTION_PREFIX = "ENC(";
    private static final String kkeystorePassword = "introscope.epagent.config.ssl.keystorepassword";
    private static final String kkeyManagerPassword = "introscope.epagent.config.ssl.keymanagerpassword";
    private FileHelper fileHelper = new FileHelper();
    private CommonEncryptionProvider cep = new CommonEncryptionProvider();
    private Boolean isKeystorePasswdEncrypted = false;
    private Boolean isKeyMngrPasswdEncrypted = false;
    private String encryptedKeystorePasswd = null;
    private String encryptedKeymngrPasswd = null;

    public void encryptPasswordsAndUpdateFile(String bundleFile, IndexedProperties properties) throws IOException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        this.isKeystorePasswdEncrypted = properties.getProperty(kkeystorePassword).startsWith(APM_ENCRYPTION_PREFIX);
        this.isKeyMngrPasswdEncrypted = properties.getProperty(kkeyManagerPassword).startsWith(APM_ENCRYPTION_PREFIX);
        String file = this.fileHelper.readFileAsString(bundleFile);
        String updatedFile = this.encryptPasswordFromFile(file);
        if (!this.isKeystorePasswdEncrypted.booleanValue() || !this.isKeyMngrPasswdEncrypted.booleanValue()) {
            this.updateFile(bundleFile, updatedFile);
        }
    }

    private void updateFile(String file, String updatedContent) throws IOException {
        this.fileHelper.reWriteFile(file, updatedContent);
    }

    private String encryptPasswordFromFile(String file) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        StringBuffer stringBuffer = null;
        if (!this.isKeystorePasswdEncrypted.booleanValue()) {
            stringBuffer = new StringBuffer();
            Matcher keystorePswdMatcher = keystorepasswordRelacementPattern.matcher(file);
            while (keystorePswdMatcher.find()) {
                if (keystorePswdMatcher.group(2).startsWith(APM_ENCRYPTION_PREFIX)) continue;
                this.encryptedKeystorePasswd = this.encryptPassword(keystorePswdMatcher.group(2));
                keystorePswdMatcher.appendReplacement(stringBuffer, keystorePswdMatcher.group(1) + this.encryptPassword(this.encryptedKeystorePasswd));
            }
            keystorePswdMatcher.appendTail(stringBuffer);
        }
        if (!this.isKeyMngrPasswdEncrypted.booleanValue()) {
            Matcher keyMngrPswdMatcher = null;
            keyMngrPswdMatcher = this.isKeystorePasswdEncrypted == false ? keyManagerpasswordRelacementPattern.matcher(stringBuffer.toString()) : keyManagerpasswordRelacementPattern.matcher(file);
            stringBuffer = new StringBuffer();
            while (keyMngrPswdMatcher.find()) {
                if (keyMngrPswdMatcher.group(2).startsWith(APM_ENCRYPTION_PREFIX)) continue;
                this.encryptedKeymngrPasswd = this.encryptPassword(keyMngrPswdMatcher.group(2));
                keyMngrPswdMatcher.appendReplacement(stringBuffer, keyMngrPswdMatcher.group(1) + this.encryptPassword(this.encryptedKeymngrPasswd));
            }
            keyMngrPswdMatcher.appendTail(stringBuffer);
        }
        if (stringBuffer != null && stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return file;
    }

    private String encryptPassword(String password) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        String encryptedPassword = password;
        if (encryptedPassword != null && !encryptedPassword.equals("") && !encryptedPassword.startsWith(APM_ENCRYPTION_PREFIX)) {
            encryptedPassword = APM_ENCRYPTION_PREFIX + this.cep.encrypt(password);
        }
        return encryptedPassword;
    }
}

