/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent.cron;

import com.wily.introscope.epagent.cron.CronEntryScheduleException;
import com.wily.introscope.epagent.cron.ICronJob;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import java.util.StringTokenizer;

class CronEntry {
    private static final String[] kEmptyNames = new String[0];
    private static final String[] kMonthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] kDayNames = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    private boolean[] mMinutes = new boolean[60];
    private boolean[] mHours = new boolean[24];
    private boolean[] mDaysOfMonth = new boolean[31];
    private boolean[] mMonths = new boolean[12];
    private boolean[] mDaysOfWeek = new boolean[8];
    private boolean mRunAllDaysOfWeek = false;
    private boolean mRunAllDaysOfMonth = false;
    private ICronJob mJob = null;

    boolean[] getMinutes() {
        return this.mMinutes;
    }

    boolean[] getHours() {
        return this.mHours;
    }

    boolean[] getDaysOfMonth() {
        return this.mDaysOfMonth;
    }

    boolean[] getMonths() {
        return this.mMonths;
    }

    boolean[] getDaysOfWeek() {
        return this.mDaysOfWeek;
    }

    boolean runAllDaysOfWeek() {
        return this.mRunAllDaysOfWeek;
    }

    boolean runAllDaysOfMonth() {
        return this.mRunAllDaysOfMonth;
    }

    ICronJob getJob() {
        return this.mJob;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CronEntry(IModuleFeedbackChannel feecback, IStringLocalizer localizer, String scheduleString, ICronJob job) throws CronEntryScheduleException {
        this.mJob = job;
        String schedule = scheduleString.toLowerCase();
        try {
            int index;
            block13: {
                block14: {
                    block16: {
                        block15: {
                            if ('@' != schedule.charAt(0)) break block14;
                            if (!schedule.startsWith("@yearly") && !schedule.startsWith("@annually")) break block15;
                            CronEntry.setBit(this.mMinutes, 0);
                            CronEntry.setBit(this.mHours, 0);
                            CronEntry.setBit(this.mDaysOfMonth, 0);
                            CronEntry.setBit(this.mMonths, 0);
                            CronEntry.setBits(this.mDaysOfWeek);
                            break block13;
                        }
                        if (!schedule.startsWith("@monthly")) break block16;
                        CronEntry.setBit(this.mMinutes, 0);
                        CronEntry.setBit(this.mHours, 0);
                        CronEntry.setBit(this.mDaysOfMonth, 0);
                        CronEntry.setBits(this.mMonths);
                        CronEntry.setBits(this.mDaysOfWeek);
                        break block13;
                    }
                    if (schedule.startsWith("@weekly")) {
                        CronEntry.setBit(this.mMinutes, 0);
                        CronEntry.setBit(this.mHours, 0);
                        CronEntry.setBits(this.mDaysOfMonth);
                        CronEntry.setBits(this.mMonths);
                        CronEntry.setBit(this.mDaysOfWeek, 0);
                        break block13;
                    } else if (schedule.startsWith("@daily") || schedule.startsWith("@midnight")) {
                        CronEntry.setBit(this.mMinutes, 0);
                        CronEntry.setBit(this.mHours, 0);
                        CronEntry.setBits(this.mDaysOfMonth);
                        CronEntry.setBits(this.mMonths);
                        CronEntry.setBits(this.mDaysOfWeek);
                        break block13;
                    } else {
                        if (!schedule.startsWith("@hourly")) {
                            String s = localizer.IStringLocalizer_getFormattedLocalizedString("invalid_keyword_1P", scheduleString);
                            throw new CronEntryScheduleException(s);
                        }
                        CronEntry.setBit(this.mMinutes, 0);
                        CronEntry.setBits(this.mHours);
                        CronEntry.setBits(this.mDaysOfMonth);
                        CronEntry.setBits(this.mMonths);
                        CronEntry.setBits(this.mDaysOfWeek);
                    }
                    break block13;
                }
                StringTokenizer st = new StringTokenizer(schedule);
                if (5 != st.countTokens()) {
                    String s = localizer.IStringLocalizer_getFormattedLocalizedString("wrong_field_count_1P", scheduleString);
                    throw new CronEntryScheduleException(s);
                }
                try {
                    CronEntry.parseList(st.nextToken(), this.mMinutes, kEmptyNames, false);
                    CronEntry.parseList(st.nextToken(), this.mHours, kEmptyNames, false);
                    CronEntry.parseList(st.nextToken(), this.mDaysOfMonth, kEmptyNames, true);
                    CronEntry.parseList(st.nextToken(), this.mMonths, kMonthNames, true);
                    CronEntry.parseList(st.nextToken(), this.mDaysOfWeek, kDayNames, false);
                }
                catch (NotANumberOrWordException e) {
                    String s = localizer.IStringLocalizer_getFormattedLocalizedString("invalid_word_or_number_2P", e.getMessage(), scheduleString);
                    throw new CronEntryScheduleException(s);
                }
            }
            if (this.mDaysOfWeek[0] || this.mDaysOfWeek[7]) {
                CronEntry.setBit(this.mDaysOfWeek, 0);
                CronEntry.setBit(this.mDaysOfWeek, 7);
            }
            this.mRunAllDaysOfMonth = this.mDaysOfMonth[0];
            for (index = 1; index < this.mDaysOfMonth.length; this.mRunAllDaysOfMonth &= this.mDaysOfMonth[index], ++index) {
            }
            this.mRunAllDaysOfWeek = this.mDaysOfWeek[0];
            for (index = 1; index < this.mDaysOfWeek.length; this.mRunAllDaysOfWeek &= this.mDaysOfWeek[index], ++index) {
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String s = localizer.IStringLocalizer_getFormattedLocalizedString("number_out_of_range_2P", e.getMessage(), scheduleString);
            throw new CronEntryScheduleException(s);
        }
    }

    private static void parseList(String list, boolean[] bits, String[] names, boolean oneBased) throws NotANumberOrWordException {
        CronEntry.clearBits(bits);
        StringTokenizer st = new StringTokenizer(list, ",");
        while (st.hasMoreTokens()) {
            CronEntry.parseRange(st.nextToken(), bits, names, oneBased);
        }
    }

    private static void parseRange(String range, boolean[] bits, String[] names, boolean oneBased) throws NotANumberOrWordException {
        int step = 1;
        int begin = 0;
        int end = bits.length - 1;
        int stepIndex = range.indexOf(47);
        if (-1 != stepIndex) {
            String stepString = range.substring(stepIndex + 1);
            step = Integer.parseInt(stepString);
            range = range.substring(0, stepIndex);
        }
        if (!range.equals("*")) {
            int dashIndex = range.indexOf(45);
            if (-1 != dashIndex) {
                String beginString = range.substring(0, dashIndex);
                begin = CronEntry.getNumber(beginString, names, oneBased);
                String endString = range.substring(dashIndex + 1);
                end = CronEntry.getNumber(endString, names, oneBased);
            } else {
                begin = end = CronEntry.getNumber(range, names, oneBased);
            }
        }
        for (int index = begin; index <= end; index += step) {
            CronEntry.setBit(bits, index);
        }
    }

    private static int getNumber(String numberOrWord, String[] names, boolean oneBased) throws NotANumberOrWordException {
        try {
            int value = Integer.parseInt(numberOrWord);
            if (oneBased) {
                --value;
            }
            return value;
        }
        catch (NumberFormatException nfe) {
            for (int index = 0; index < names.length; ++index) {
                if (!names[index].equalsIgnoreCase(numberOrWord)) continue;
                return index;
            }
            throw new NotANumberOrWordException(numberOrWord);
        }
    }

    private static void setBit(boolean[] bits, int offset) {
        bits[offset] = true;
    }

    private static void setBits(boolean[] bits) {
        CronEntry.setBits(bits, 0, bits.length);
    }

    private static void setBits(boolean[] bits, int offset, int length) {
        for (int index = offset; index < offset + length; ++index) {
            bits[index] = true;
        }
    }

    private static void clearBits(boolean[] bits) {
        CronEntry.clearBits(bits, 0, bits.length);
    }

    private static void clearBits(boolean[] bits, int offset, int length) {
        for (int index = offset; index < offset + length; ++index) {
            bits[index] = false;
        }
    }

    private static class NotANumberOrWordException
    extends Exception {
        private static final long serialVersionUID = -4876887097811181199L;

        NotANumberOrWordException(String message) {
            super(message);
        }
    }
}

