/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent.http;

import com.google.gson.JsonParseException;
import com.wily.introscope.epagent.api.IllegalMetricNameException;
import com.wily.introscope.epagent.api.IllegalMetricTypeException;
import com.wily.introscope.epagent.api.IllegalValueException;
import com.wily.introscope.epagent.api.MetricClampExceededException;
import com.wily.introscope.epagent.http.MetricFeedBundle;
import java.util.ArrayList;
import java.util.List;

public class HttpServerError {
    public static final String INVALID_REQUEST_MSG = "Invalid Request.  A valid request must have a Content-Type header.  The only supported value is application/json.  A valid request must have a valid json payload containing a metrics object.  A valid request may have a Content-Encoding header.  Supported encodings are gzip, x-gzip, and identity.  A valid request may specify a charset in the Content-Type header.  The specified charset must be supported by the installed java implementation";
    public static final int INVALID_REQUEST_CODE = 1000;
    public static final String INVALID_JSON_MSG = "Invalid JSON";
    public static final int INVALID_JSON_CODE = 1001;
    public static final String INVALID_METRICS_MSG = "One or more metric specifications were invalid";
    public static final int INVALID_METRICS_CODE = 1010;
    public static final String INVALID_METRIC_NAME_MSG = "Invalid metric name";
    public static final int INVALID_METRIC_NAME_CODE = 1011;
    public static final String INVALID_METRIC_TYPE_MSG = "Invalid metric type";
    public static final int INVALID_METRIC_TYPE_CODE = 1012;
    public static final String INVALID_METRIC_VALUE_MSG = "Invalid metric value";
    public static final int INVALID_METRIC_VALUE_CODE = 1013;
    public static final String METRIC_CLAMP_EXCEEDED_MSG = "Metric clamp exceeded";
    public static final int METRIC_CLAMP_EXCEEDED_CODE = 1014;
    public static final int MAX_METRIC_ERROR_COUNT = 100;
    private String errorMessage;
    private Integer errorCode;
    private Integer invalidCount;
    private int validCount;
    private String errorDetail;
    private List<MetricError> metricErrors;

    public HttpServerError() {
    }

    public HttpServerError(Exception ex) {
        this.errorDetail = ex.getMessage();
        if (ex instanceof JsonParseException) {
            this.errorMessage = INVALID_JSON_MSG;
            this.errorCode = 1001;
        } else {
            this.errorMessage = INVALID_REQUEST_MSG;
            this.errorCode = 1000;
        }
    }

    public HttpServerError(String inmsg, int incode) {
        this.errorMessage = inmsg;
        this.errorCode = incode;
    }

    public void addMetricError(String name, Exception ex, int index, MetricFeedBundle.MetricInfo metric) {
        if (this.metricErrors == null) {
            this.metricErrors = new ArrayList<MetricError>();
        }
        this.addMetricError(new MetricError(name, ex, index, metric));
    }

    public void addMetricError(String name, int errorCode, String errorMsg, int index, MetricFeedBundle.MetricInfo metric) {
        if (this.metricErrors == null) {
            this.metricErrors = new ArrayList<MetricError>();
        }
        this.addMetricError(new MetricError(name, errorCode, errorMsg, index, metric));
    }

    private void addMetricError(MetricError me) {
        if (this.metricErrors.size() < 100) {
            this.metricErrors.add(me);
        }
    }

    public HttpServerError setValidCount(int count) {
        this.validCount = count;
        return this;
    }

    public HttpServerError setInvalidCount(int count) {
        if (count > 0) {
            this.invalidCount = count;
        }
        return this;
    }

    public int getValidCount() {
        return this.validCount;
    }

    public int getInvalidCount() {
        return this.invalidCount == null ? 0 : this.invalidCount;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDetail() {
        return this.errorDetail;
    }

    public List<MetricError> getMetricErrors() {
        return this.metricErrors;
    }

    public static class MetricError {
        private String metricName;
        private int metricErrorCode;
        private String metricErrorMsg;
        private int metricErrorIndex;
        private MetricFeedBundle.MetricInfo metric;

        public MetricError() {
        }

        public MetricError(String inname, Exception ex, int index, MetricFeedBundle.MetricInfo metricInError) {
            this.metricName = inname;
            this.metricErrorIndex = index;
            if (ex instanceof IllegalMetricNameException) {
                this.metricErrorMsg = HttpServerError.INVALID_METRIC_NAME_MSG;
                this.metricErrorCode = 1011;
            } else if (ex instanceof IllegalMetricTypeException) {
                this.metricErrorMsg = HttpServerError.INVALID_METRIC_TYPE_MSG;
                this.metricErrorCode = 1012;
            } else if (ex instanceof IllegalValueException) {
                this.metricErrorMsg = HttpServerError.INVALID_METRIC_VALUE_MSG;
                this.metricErrorCode = 1013;
            } else if (ex instanceof MetricClampExceededException) {
                this.metricErrorMsg = HttpServerError.METRIC_CLAMP_EXCEEDED_MSG;
                this.metricErrorCode = 1014;
            } else {
                this.metricErrorMsg = ex.toString();
                this.metricErrorCode = 1010;
            }
            this.metric = metricInError;
        }

        public MetricError(String name, int errorCode, String errorMsg, int index, MetricFeedBundle.MetricInfo metricInError) {
            this.metricName = name;
            this.metricErrorCode = errorCode;
            this.metricErrorMsg = errorMsg;
            this.metricErrorIndex = index;
            this.metric = metricInError;
        }

        public int getMetricErrorIndex() {
            return this.metricErrorIndex;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public int getMetricErrorCode() {
            return this.metricErrorCode;
        }

        public String getMetricErrorMsg() {
            return this.metricErrorMsg;
        }

        public MetricFeedBundle.MetricInfo getMetric() {
            return this.metric;
        }
    }
}

