/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.externalId;

import com.google.gson.GsonBuilder;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.externalId.ExternalIdExtractor;
import com.wily.introscope.agent.externalId.MetricExternalIdLogger;
import com.wily.introscope.agent.externalId.model.ExternalIdPatternSerializer;
import com.wily.introscope.agent.externalId.model.MetricExternalIdDefinition;
import com.wily.introscope.agent.externalId.model.MetricExternalIdDefinitions;
import com.wily.util.properties.IndexedProperties;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class APMMetricExternalIdService {
    private static final String metricExternalIdPropertyKey = "introscope.agent.nass.metric.externalId.";
    private static final APMMetricExternalIdService INSTANCE = new APMMetricExternalIdService();
    private final Map<String, ExternalIdExtractor> metricExtractorMap = new HashMap<String, ExternalIdExtractor>();

    public static APMMetricExternalIdService getInstance() {
        return INSTANCE;
    }

    public ExternalIdExtractor getExtractor(String input) {
        for (Map.Entry<String, ExternalIdExtractor> entry : this.metricExtractorMap.entrySet()) {
            if (!entry.getValue().matchMetricPath(input)) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<String, ExternalIdExtractor> getMetricExtractorMap() {
        return this.metricExtractorMap;
    }

    private APMMetricExternalIdService() {
        this.getMetricExternalIdDefinitions();
    }

    private void getMetricExternalIdDefinitions() {
        try {
            IndexedProperties properties = AgentShim.getAgent().IAgent_getIndexedProperties();
            if (!properties.getBooleanProperty("introscope.agent.nass.metric.ingestion.enabled", false)) {
                return;
            }
            for (String propkey : properties.getAllKeys()) {
                if (!propkey.startsWith(metricExternalIdPropertyKey)) continue;
                String metricExternalIdFilePath = properties.getProperty(propkey);
                MetricExternalIdLogger.getLogger().info("Processing property: " + propkey + " value: " + metricExternalIdFilePath);
                try {
                    File metricExternalIdFile = new File(metricExternalIdFilePath);
                    if (!metricExternalIdFile.exists()) continue;
                    MetricExternalIdDefinitions metricExternalIdDefinitions = (MetricExternalIdDefinitions)new GsonBuilder().registerTypeAdapter(Pattern.class, (Object)new ExternalIdPatternSerializer()).create().fromJson((Reader)new FileReader(metricExternalIdFile), MetricExternalIdDefinitions.class);
                    MetricExternalIdLogger.getLogger().info("externalId metric json file parsed successfully - " + metricExternalIdFile);
                    this.populateExtractorMap(metricExternalIdDefinitions, properties);
                }
                catch (Exception exp) {
                    MetricExternalIdLogger.getLogger().warn("Error while loading externalId metric json file. Exception: " + exp.getMessage());
                }
            }
        }
        catch (Exception exp) {
            MetricExternalIdLogger.getLogger().warn("Error while loading externalId metric definitions. Exception: " + exp);
        }
    }

    private void populateExtractorMap(MetricExternalIdDefinitions metricExternalIdDefinitions, IndexedProperties properties) {
        for (MetricExternalIdDefinition metricExternalIdDefinition : metricExternalIdDefinitions.getMetricExternalIdDefinitionList()) {
            if (this.metricExtractorMap.containsKey(metricExternalIdDefinition.getMetricPathRegex())) continue;
            ExternalIdExtractor extractor = new ExternalIdExtractor(metricExternalIdDefinition, properties);
            this.metricExtractorMap.put(metricExternalIdDefinition.getMetricPathRegex(), extractor);
        }
    }
}

