/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.ICallbackOnObjectKeyNotFound;
import com.wily.introscope.agent.sqlagent.SQLAgentConfiguration;
import com.wily.introscope.agent.sqlagent.StatementNormalizer;
import com.wily.introscope.agent.sqlagent.StatementToSQLMappingTracer;
import com.wily.introscope.agent.sqlagent.hc2.SQLObjectKeyHelper;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.trace.jdbc.SQLNameFormatterUtilities;
import com.wily.util.WilyStringBuilder;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import java.sql.Connection;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class DatabaseNameFormatter
implements ICacheableBlameKeyNameFormatter,
ICallbackOnObjectKeyNotFound {
    private IModuleFeedbackChannel fFeedback;
    private IStringLocalizer fLocalizer;
    private SQLAgentConfiguration fConfiguration;
    private static final char[] kUrlPlaceHolder = new String("{url}").toCharArray();
    private static final char[] kDatabasePlaceHolder = new String("{database}").toCharArray();
    private static final char[] kCommandTypePlaceHolder = new String("{commandtype}").toCharArray();
    private static final char[] kNormalizedSQLPlaceHolder = new String("{sql}").toCharArray();
    public static final String kNormalizedDynamicSQLCacheKey = "com.wily.introscope.agent.sqlagent.dynamic.query.normalized.sql.cache";
    private static AtomicInteger fCounter = new AtomicInteger(0);
    private static final int kMaxCounter = 100;
    private static ThreadLocal NameFormatterBuilder = new ThreadLocal(){

        protected Object initialValue() {
            return new WilyStringBuilder();
        }
    };

    public DatabaseNameFormatter(IAgent agent) {
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fLocalizer = agent.IAgent_getStringLocalizer();
        this.fConfiguration = SQLAgentConfiguration.getInstance(agent);
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String result = name;
        try {
            if (name != null) {
                int cmdIndex;
                int sqlIndex;
                int urlIndex;
                WilyStringBuilder bldr = (WilyStringBuilder)NameFormatterBuilder.get();
                bldr.setString(name);
                int dbIndex = bldr.indexOf(kDatabasePlaceHolder);
                if (dbIndex >= 0) {
                    bldr = bldr.replace(dbIndex, dbIndex + kDatabasePlaceHolder.length, this.getDatabaseName(this.fFeedback, data));
                }
                if ((urlIndex = bldr.indexOf(kUrlPlaceHolder)) >= 0) {
                    bldr = bldr.replace(urlIndex, urlIndex + kUrlPlaceHolder.length, this.getURL(this.fFeedback, data));
                }
                if ((sqlIndex = bldr.indexOf(kNormalizedSQLPlaceHolder)) >= 0) {
                    String sql = this.getNormalizedSQL(this.fFeedback, data);
                    if (sql != null && sql.equals("Default")) {
                        bldr = bldr.replace(bldr.indexOf(kCommandTypePlaceHolder), bldr.length(), sql);
                        result = bldr.toString();
                        return result;
                    }
                    bldr = bldr.replace(sqlIndex, sqlIndex + kNormalizedSQLPlaceHolder.length, sql);
                }
                if ((cmdIndex = bldr.indexOf(kCommandTypePlaceHolder)) >= 0) {
                    bldr = bldr.replace(cmdIndex, cmdIndex + kCommandTypePlaceHolder.length, this.getCommandType(this.fFeedback, data));
                }
                result = bldr.toString();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.fFeedback.error("An error occurred formatting database name.");
                this.fFeedback.verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public String getURL(IModuleFeedbackChannel feedback, InvocationData data) {
        Connection c = this.getConnection(feedback, data.getInvocationObject(), data);
        return SQLNameFormatterUtilities.getSafeCachedURL(feedback, c);
    }

    @Override
    public String getURL(IModuleFeedbackChannel feedback, InvocationData data, Object conn) {
        Connection c = conn instanceof Connection ? (Connection)conn : this.getConnection(feedback, data.getInvocationObject(), data);
        String url = SQLNameFormatterUtilities.getSafeCachedURL(feedback, c);
        if (SQLNameFormatterUtilities.isIgnoreUnknownUrlType() && SQLNameFormatterUtilities.getConnectionClassName(conn).equalsIgnoreCase(url)) {
            data.put("ignoreUnknownUrlType", (Object)Boolean.TRUE);
            if (feedback.isTraceEnabled()) {
                feedback.trace("Ignore to send metrics and TT for the class: " + conn.getClass().getName());
            }
        }
        return url;
    }

    protected SQLAgentConfiguration getConfiguration() {
        return this.fConfiguration;
    }

    protected abstract Connection getConnection(IModuleFeedbackChannel var1, Object var2, InvocationData var3);

    public String getDatabaseName(IModuleFeedbackChannel feedback, InvocationData data) {
        String name = null;
        try {
            Connection conn = this.getConnection(feedback, data.getInvocationObject(), data);
            SQLNameFormatterUtilities utilities = SQLNameFormatterUtilities.getInstance();
            name = utilities.getFormattedString(conn, this.getURL(feedback, data, conn), this.fFeedback, this.fLocalizer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name == null) {
            name = "Unknown Driver";
        }
        return name;
    }

    public String getCommandType(IModuleFeedbackChannel feedback, InvocationData data) {
        return DatabaseNameFormatter.getCommandType();
    }

    public static String getCommandType() {
        return "Unknown";
    }

    public String getNormalizedSQL(IModuleFeedbackChannel feedback, InvocationData data) {
        return DatabaseNameFormatter.getNormalizedSQL(feedback, data, this.fConfiguration.getNormalizedMaxSQLLength());
    }

    public static String getNormalizedSQL(IModuleFeedbackChannel feedback, InvocationData data, int maxLength) {
        String normalizedSQLForMetricName = (String)data.get(kNormalizedDynamicSQLCacheKey);
        if (normalizedSQLForMetricName == null) {
            try {
                Statement stmt = (Statement)data.getInvocationObject();
                if (data.getInvocationParameterCount() > 0) {
                    String rawSQL = null;
                    Object rawSQLObj = data.getInvocationParameterAsObject(0);
                    if (rawSQLObj != null && rawSQLObj instanceof String) {
                        rawSQL = (String)rawSQLObj;
                        normalizedSQLForMetricName = StatementToSQLMappingTracer.getRawToNormalizedMapping(rawSQL);
                        if (normalizedSQLForMetricName == null) {
                            normalizedSQLForMetricName = StatementNormalizer.normalizeSQL(rawSQL, maxLength);
                            StatementToSQLMappingTracer.putRawToNormalizedMapping(rawSQL, normalizedSQLForMetricName);
                        }
                        String normalizedSQLForUserView = StatementNormalizer.normalizeSQLForUserView(rawSQL, normalizedSQLForMetricName, maxLength);
                        Object shouldBeStatement = data.getInvocationObject();
                        if (shouldBeStatement instanceof Statement) {
                            StatementToSQLMappingTracer.putMapping(shouldBeStatement, normalizedSQLForMetricName, normalizedSQLForUserView, "Dynamic");
                        }
                    }
                } else {
                    normalizedSQLForMetricName = StatementToSQLMappingTracer.getSQL(stmt);
                }
            }
            catch (Throwable e) {
                normalizedSQLForMetricName = null;
                try {
                    feedback.error("Failed to normalize SQL.");
                    feedback.verbose(e);
                }
                catch (Throwable rawSQL) {
                    // empty catch block
                }
            }
            if (normalizedSQLForMetricName == null) {
                normalizedSQLForMetricName = "Unknown SQL";
                if (feedback.isDebugEnabled() && fCounter.getAndIncrement() < 100) {
                    String classNameToBeReported = data.getInvocationObject().getClass().getName();
                    if (fCounter.get() == 100) {
                        feedback.debug("The 100 of \"SkipClass\" messages has been reported. The output suppressed till the next start.");
                    }
                    if (classNameToBeReported != null) {
                        StringBuilder buff = new StringBuilder();
                        buff.append("Could not find normalized sql for statement: " + String.valueOf(data.getInvocationObject())).append(".");
                        buff.append("Please insert \"SkipClass: ").append(classNameToBeReported).append("\" in .pbd to suppress \"Unknown SQL\" metrics.");
                        feedback.debug(buff.toString());
                    }
                }
            }
            data.put(kNormalizedDynamicSQLCacheKey, (Object)normalizedSQLForMetricName);
        }
        return normalizedSQLForMetricName;
    }

    public static String getNormalizedSQLForUserView(IModuleFeedbackChannel feedback, InvocationData data, int maxLength) {
        Statement stmt = (Statement)data.getInvocationObject();
        String normalizedSQLForUserView = StatementToSQLMappingTracer.getSQL(stmt, false);
        if (normalizedSQLForUserView == null && data.getInvocationParameterCount() > 0) {
            String rawSQL = null;
            Object rawSQLObj = data.getInvocationParameterAsObject(0);
            if (rawSQLObj != null && rawSQLObj instanceof String) {
                rawSQL = (String)rawSQLObj;
                normalizedSQLForUserView = StatementNormalizer.normalizeSQLForUserView(rawSQL, null, maxLength);
            }
        }
        if (normalizedSQLForUserView == null) {
            normalizedSQLForUserView = "Unknown SQL";
            if (feedback.isDebugEnabled() && fCounter.getAndIncrement() < 100) {
                String classNameToBeReported = data.getInvocationObject().getClass().getName();
                if (fCounter.get() == 100) {
                    feedback.debug("The 100 of \"SkipClass\" messages has been repoted. The output suppressed till the next start.");
                }
                if (classNameToBeReported != null) {
                    StringBuilder buff = new StringBuilder();
                    buff.append("Please insert \"SkipClass: ").append(classNameToBeReported).append("\" in .pbd to suppress \"Unknown SQL\" metrics.");
                    feedback.debug(buff.toString());
                }
            }
        }
        return normalizedSQLForUserView;
    }

    protected IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel feedback, String name, InvocationData data) {
        Object URL2 = null;
        try {
            URL2 = SQLObjectKeyHelper.getURL(data, feedback, data.getInvocationObject(), this);
            if (URL2 == null) {
                URL2 = data.getInvocationObject().toString();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            return null;
        }
        if (data.getInvocationParameterCount() > 0) {
            return ABlameComponent.getArrayInstance((Object[])new Object[]{data.getInvocationParameterAsObject(0), name, URL2});
        }
        return ABlameComponent.getInstance((Object)name, (Object)URL2);
    }
}

