/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.exitpoint.stacktrace;

import com.wily.introscope.agent.intelligent.detection.BaseCandidateFinder;
import com.wily.introscope.agent.intelligent.detection.RecordingData;
import com.wily.introscope.agent.intelligent.detection.TraceRecordingFilter;
import com.wily.introscope.agent.intelligent.detection.TraceRecordingListener;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointCandidateFinder;
import com.wily.introscope.agent.intelligent.exitpoint.stacktrace.TraceRecordingTicketMaster;

public class ThreadSelector
implements TraceRecordingFilter,
TraceRecordingListener {
    private final BaseCandidateFinder finder = ExitPointCandidateFinder.getInstance();
    private final TraceRecordingTicketMaster ticketMaster = TraceRecordingTicketMaster.getInstance();
    private volatile int recordingsLimitPerThread = 5;

    @Override
    public boolean shouldRecordTrace(RecordingData threadLocalData) {
        int runNumber = this.finder.currentRunNumber();
        return this.isQualifiedForRun(threadLocalData, runNumber, threadLocalData.getRunSelectionId());
    }

    private boolean isQualifiedForRun(RecordingData threadLocalData, int runNumber, int runSelectionId) {
        if (threadLocalData.isThreadRejected()) {
            return false;
        }
        if (threadLocalData.isThreadStatusPending()) {
            threadLocalData.setThreadSelectionStatus(this.ticketMaster.requestTicket());
        }
        return threadLocalData.isThreadPicked() && threadLocalData.getRecordingsCount() < this.recordingsLimitPerThread;
    }

    @Override
    public void notifyOnRecording(RecordingData threadLocalData) {
        threadLocalData.incrementAndGetRecordingsCount();
    }

    public void setStackTracesLimitPerThread(int limit) {
        this.recordingsLimitPerThread = limit;
    }

    public int getStackTracesLimitPerThread() {
        return this.recordingsLimitPerThread;
    }

    public void resetSelectionId(RecordingData threadLocalData) {
        threadLocalData.setRunSelectionId(0);
    }
}

