/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent;

import com.wily.introscope.epagent.ClassPlugin;
import com.wily.introscope.epagent.CommonEncryptionProvider;
import com.wily.introscope.epagent.EPAPlugin;
import com.wily.introscope.epagent.EPAPluginProcessor;
import com.wily.introscope.epagent.EPAgent;
import com.wily.introscope.epagent.EncryptionHelper;
import com.wily.introscope.epagent.IPluginClassLookupHelper;
import com.wily.introscope.epagent.IPluginProcessor;
import com.wily.introscope.epagent.IllegalConfigurationException;
import com.wily.introscope.epagent.ProcessPlugin;
import com.wily.introscope.epagent.api.DataRecorderFactory;
import com.wily.introscope.epagent.api.IllegalMetricNameException;
import com.wily.introscope.epagent.api.StringEventDataRecorder;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class EPAConfig {
    static final String kPrefsFileName = "IntroscopeEPAgent.properties";
    static final String kPrefsKey = "com.wily.fieldeng.epagent.properties";
    static final String kPrefsKey2 = "com.wily.introscope.epagent.properties";
    static final String kStatefulPrefixKey = "introscope.epagent.stateful";
    static final String kStatefulNamesKey = "introscope.epagent.plugins.stateful.names";
    static final String kStatelessPrefixKey = "introscope.epagent.stateless";
    static final String kStatelessNamesKey = "introscope.epagent.plugins.stateless.names";
    static final String kNamesSuffixKey = ".names";
    private static final String kPluginTimeout = "introscope.epagent.config.stalledStatelessPluginTimeoutInSeconds";
    private static final String kNetworkPort = "introscope.epagent.config.networkDataPort";
    private static final String kHttpPort = "introscope.epagent.config.httpServerPort";
    private static final String ksslEnabled = "introscope.epagent.config.sslEnabled";
    private static final String kkeystorePath = "introscope.epagent.config.ssl.keystorepath";
    private static final String kkeystorePassword = "introscope.epagent.config.ssl.keystorepassword";
    private static final String kkeyManagerPassword = "introscope.epagent.config.ssl.keymanagerpassword";
    private static final String kintroscoprProfileLocation = "com.wily.introscope.agentProfile";
    private static final String kMetricCaseSensitive = "introscope.epagent.metricscasesensitive";
    private static final String kHttpServerMinThreadCount = "introscope.epagent.config.HttpServer.minThreadCount";
    private static final String kHttpServerMaxThreadCount = "introscope.epagent.config.HttpServer.maxThreadCount";
    private static final String kHttpServerMaxQueuedCount = "introscope.epagent.config.HttpServer.maxQueuedCount";
    private static final String kHttpServerMaxIdleTimeMS = "introscope.epagent.config.HttpServer.maxIdleTimeMS";
    private static final String kHttpServerMaxIdleTime = "introscope.epagent.config.HttpServer.maxIdleTime";
    private static final String kHttpServerAcceptQueueSize = "introscope.epagent.config.HttpServer.acceptQueueSize";
    private static final String kStaleMetricRemovalInterval = "introscope.epagent.config.staleMetricsRemoval.intervalInSec";
    static final String kCommandSubKey = "command";
    private static final String kClassSubKey = "class";
    private static final String APM_ENCRYPTION_PREFIX = "ENC(";
    private Vector<EPAPlugin> fPlugins = new Vector();
    private EPAPluginProcessor fPluginProcessor;
    private int fPluginTimeout = 60000;
    private int fNetworkPort = -1;
    private int fHttpPort = -1;
    private boolean fMetricCaseSensitive = false;
    private boolean fsslEnabled = false;
    private String fkeystorePath = null;
    private String fkeystorePassword = null;
    private String fkeyManagerPassword = null;
    private String fintroscopeProfileLocation = null;
    private int fHttpServerMinThreadCount = 2;
    private int fHttpServerMaxThreadCount = 20;
    private int fHttpServerMaxQueuedCount = 50;
    private int fHttpServerMaxIdleTimeMS = 1800000;
    private int fHttpServerMaxIdleTime = 1000;
    private int fHttpServerAcceptQueueSize = 50;
    private int fStaleMetricsRemovalInterval = 0;
    private StringEventDataRecorder fNetworkPortRecorder;
    private StringEventDataRecorder fHttpPortRecorder;
    private StringEventDataRecorder fPluginTimeoutRecorder;
    private StringEventDataRecorder fMetricCaseSensitiveRecorder;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final IPluginClassLookupHelper fClassHelper;
    protected final Module fModule = new Module("EPAgent");
    private static final CommonEncryptionProvider cep = new CommonEncryptionProvider();

    public EPAConfig(IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this(feedback, localizer, null);
    }

    public EPAConfig(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPluginClassLookupHelper classHelper) {
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fClassHelper = classHelper;
    }

    public IPluginClassLookupHelper getClassHelper() {
        return this.fClassHelper;
    }

    public Vector<EPAPlugin> getPlugins() {
        return this.fPlugins;
    }

    public IPluginProcessor getPluginProcessor() {
        return this.fPluginProcessor;
    }

    public int getPluginTimeout() {
        return this.fPluginTimeout;
    }

    public boolean detectStalledPlugins() {
        return 0 != this.fPluginTimeout;
    }

    public int getNetworkPort() {
        return this.fNetworkPort;
    }

    public boolean createNetworkServer() {
        return -1 != this.fNetworkPort;
    }

    public int getHttpPort() {
        return this.fHttpPort;
    }

    public boolean createHttpServer() {
        return -1 != this.fHttpPort;
    }

    public boolean getMetricCaseSensitive() {
        return this.fMetricCaseSensitive;
    }

    public boolean isSslEnabled() {
        return this.fsslEnabled;
    }

    public String getKeyStorePath() {
        return this.fkeystorePath;
    }

    public String getKeyStorePassword() {
        return this.fkeystorePassword;
    }

    public String getKeyManagerPassword() {
        return this.fkeyManagerPassword;
    }

    public int getHttpServerMinThreadCount() {
        return this.fHttpServerMinThreadCount;
    }

    public int getHttpServerMaxThreadCount() {
        return this.fHttpServerMaxThreadCount;
    }

    public int getHttpServerMaxQueuedCount() {
        return this.fHttpServerMaxQueuedCount;
    }

    public int getHttpServerMaxIdleTimeMS() {
        return this.fHttpServerMaxIdleTimeMS;
    }

    public int getHttpServerMaxIdleTime() {
        return this.fHttpServerMaxIdleTime;
    }

    public int getHttpServerAcceptQueueSize() {
        return this.fHttpServerAcceptQueueSize;
    }

    public int getStaleMetricsRemovalInterval() {
        return this.fStaleMetricsRemovalInterval;
    }

    private String getFintroscopeProfileLocation() {
        return this.fintroscopeProfileLocation;
    }

    private void setFintroscopeProfileLocation(String fintroscopeProfileLocation) {
        this.fintroscopeProfileLocation = fintroscopeProfileLocation;
    }

    public void parseConfigFile(File prefsFile) throws IOException, IllegalConfigurationException {
        IndexedProperties properties = null;
        try (FileInputStream fis = null;){
            properties = new IndexedProperties();
            fis = new FileInputStream(prefsFile);
            properties.load((InputStream)fis);
            this.parseConfig(properties);
        }
    }

    public void parseConfig(IndexedProperties properties) throws IllegalConfigurationException {
        this.fPluginProcessor = new EPAPluginProcessor(properties, this.fFeedback, this.fLocalizer, this);
        this.parseConfig(kStatefulNamesKey, kStatefulPrefixKey, properties);
        this.parseConfig(kStatelessNamesKey, kStatelessPrefixKey, properties);
        String[] elements = kStatefulPrefixKey.split("\\.");
        int statefulPrefixElementLen = elements.length;
        elements = kStatelessPrefixKey.split("\\.");
        int statelessPrefixElementLen = elements.length;
        Enumeration keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String extensionPrefix;
            String extensionName;
            String key = (String)keys.nextElement();
            if (key.startsWith(kStatefulPrefixKey) && key.endsWith(kNamesSuffixKey) && (elements = key.split("\\.")).length == statefulPrefixElementLen + 2) {
                extensionName = elements[statefulPrefixElementLen];
                extensionPrefix = "introscope.epagent.stateful." + extensionName;
                this.parseConfig(extensionPrefix + kNamesSuffixKey, extensionPrefix, properties);
            }
            if (!key.startsWith(kStatelessPrefixKey) || !key.endsWith(kNamesSuffixKey) || (elements = key.split("\\.")).length != statefulPrefixElementLen + 2) continue;
            extensionName = elements[statelessPrefixElementLen];
            extensionPrefix = "introscope.epagent.stateless." + extensionName;
            this.parseConfig(extensionPrefix + kNamesSuffixKey, extensionPrefix, properties);
        }
        this.fNetworkPort = properties.getIntProperty(kNetworkPort, this.fNetworkPort);
        this.fHttpPort = properties.getIntProperty(kHttpPort, this.fHttpPort);
        this.fsslEnabled = properties.getBooleanProperty(ksslEnabled, false);
        this.fkeystorePath = properties.getProperty(kkeystorePath);
        if (this.fsslEnabled) {
            String introscopeProfPath = properties.getProperty(kintroscoprProfileLocation);
            if (!properties.getProperty(kkeystorePassword).startsWith(APM_ENCRYPTION_PREFIX) || !properties.getProperty(kkeyManagerPassword).startsWith(APM_ENCRYPTION_PREFIX)) {
                EncryptionHelper passwordHelper = new EncryptionHelper();
                try {
                    passwordHelper.encryptPasswordsAndUpdateFile(introscopeProfPath, properties);
                }
                catch (IOException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (InvalidKeyException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (InvalidKeySpecException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (NoSuchPaddingException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (InvalidAlgorithmParameterException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (IllegalBlockSizeException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (BadPaddingException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
            }
            if (properties.getProperty(kkeystorePassword).startsWith(APM_ENCRYPTION_PREFIX)) {
                try {
                    this.fkeystorePassword = cep.decrypt(properties.getProperty(kkeystorePassword).substring(4));
                }
                catch (InvalidKeyException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (InvalidKeySpecException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (NoSuchPaddingException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (InvalidAlgorithmParameterException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (BadPaddingException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
            } else {
                this.fkeystorePassword = properties.getProperty(kkeystorePassword);
            }
            if (properties.getProperty(kkeyManagerPassword).startsWith(APM_ENCRYPTION_PREFIX)) {
                try {
                    this.fkeyManagerPassword = cep.decrypt(properties.getProperty(kkeyManagerPassword).substring(4));
                }
                catch (InvalidKeyException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (InvalidKeySpecException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (NoSuchPaddingException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (InvalidAlgorithmParameterException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
                catch (BadPaddingException e) {
                    this.fFeedback.error(this.fModule, "Error while password encryption");
                    this.fFeedback.debug(this.fModule, "ParseConfig(): ", (Throwable)e);
                }
            } else {
                this.fkeyManagerPassword = properties.getProperty(kkeyManagerPassword);
            }
        }
        this.fHttpServerMinThreadCount = properties.getIntProperty(kHttpServerMinThreadCount, this.fHttpServerMinThreadCount);
        this.fHttpServerMaxThreadCount = properties.getIntProperty(kHttpServerMaxThreadCount, this.fHttpServerMaxThreadCount);
        this.fHttpServerMaxQueuedCount = properties.getIntProperty(kHttpServerMaxQueuedCount, this.fHttpServerMaxQueuedCount);
        this.fHttpServerMaxIdleTimeMS = properties.getIntProperty(kHttpServerMaxIdleTimeMS, this.fHttpServerMaxIdleTimeMS);
        this.fHttpServerMaxIdleTime = properties.getIntProperty(kHttpServerMaxIdleTime, this.fHttpServerMaxIdleTime);
        this.fHttpServerAcceptQueueSize = properties.getIntProperty(kHttpServerAcceptQueueSize, this.fHttpServerAcceptQueueSize);
        this.fStaleMetricsRemovalInterval = properties.getIntProperty(kStaleMetricRemovalInterval, this.fStaleMetricsRemovalInterval);
        this.fPluginTimeout = 1000 * properties.getIntProperty(kPluginTimeout, 60);
        if (this.fPluginTimeout < 0) {
            String s = EPAgent.GetLocalizer().IStringLocalizer_getFormattedLocalizedString("invalid_plugin_timeout_1P", String.valueOf(this.fPluginTimeout / 1000));
            throw new IllegalConfigurationException(s);
        }
        this.fMetricCaseSensitive = properties.getBooleanProperty(kMetricCaseSensitive, this.fMetricCaseSensitive);
        try {
            this.fNetworkPortRecorder = DataRecorderFactory.createStringEventDataRecorder("EPAgent|Config:Network Data Port");
            this.fNetworkPortRecorder.recordDataPoint(String.valueOf(this.fNetworkPort));
            this.fHttpPortRecorder = DataRecorderFactory.createStringEventDataRecorder("EPAgent|Config:HTTP Server Port");
            this.fHttpPortRecorder.recordDataPoint(String.valueOf(this.fHttpPort));
            this.fPluginTimeoutRecorder = DataRecorderFactory.createStringEventDataRecorder("EPAgent|Config:Plugin Timeout");
            this.fPluginTimeoutRecorder.recordDataPoint(String.valueOf(this.fPluginTimeout));
            this.fMetricCaseSensitiveRecorder = DataRecorderFactory.createStringEventDataRecorder("EPAgent|Config:Metric Case Sensitive");
            this.fMetricCaseSensitiveRecorder.recordDataPoint(String.valueOf(this.fMetricCaseSensitive));
        }
        catch (IllegalMetricNameException e) {
            throw new IllegalConfigurationException(e);
        }
    }

    private void parseConfig(String nameListKey, String prefixKey, IndexedProperties properties) throws IllegalConfigurationException {
        Assertion.wilyAssert((nameListKey.equals(kStatefulNamesKey) || nameListKey.equals(kStatelessNamesKey) ? 1 : 0) != 0);
        String tmp = properties.getProperty(nameListKey);
        if (tmp != null) {
            String[] nameList = StringUtils.parseAndTrimList((String)tmp, (String)",");
            for (int i = 0; i < nameList.length; ++i) {
                EPAPlugin p;
                String name = nameList[i];
                String keyRoot = prefixKey + "." + name + ".";
                String command = properties.getProperty(keyRoot + kCommandSubKey);
                if (null != command) {
                    p = new ProcessPlugin(this.fPluginProcessor, keyRoot, name, command);
                } else {
                    command = properties.getProperty(keyRoot + kClassSubKey);
                    if (null != command) {
                        p = new ClassPlugin(this.fPluginProcessor, keyRoot, name, command);
                    } else {
                        String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("invalid_plugin_type_1P", name);
                        throw new IllegalConfigurationException(s);
                    }
                }
                this.fPlugins.add(p);
            }
        }
    }
}

