/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent;

import com.wily.EDU.oswego.cs.dl.util.concurrent.Callable;
import com.wily.EDU.oswego.cs.dl.util.concurrent.TimedCallable;
import com.wily.EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import com.wily.introscope.epagent.EPAgent;
import com.wily.introscope.epagent.IPluginProcessor;
import com.wily.introscope.epagent.IllegalConfigurationException;
import com.wily.introscope.epagent.api.DataRecorderFactory;
import com.wily.introscope.epagent.api.IllegalMetricNameException;
import com.wily.introscope.epagent.api.IllegalValueException;
import com.wily.introscope.epagent.api.IntCounterDataRecorder;
import com.wily.introscope.epagent.api.LongAverageDataRecorder;
import com.wily.introscope.epagent.api.StringEventDataRecorder;
import com.wily.introscope.epagent.api.TimestampDataRecorder;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.text.IStringLocalizer;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Vector;

public abstract class EPAPlugin
implements Runnable,
Callable {
    protected final Module fModule;
    protected final IModuleFeedbackChannel fFeedback;
    protected final IStringLocalizer fLocalizer;
    private static final String kDelaySubKey = "delayInSeconds";
    private static final String kScheduleSubKey = "schedule";
    private static final String kStatelessSearchKey = ".stateless.";
    private boolean fStateless;
    private int fInterval = -1;
    private String fCronSchedule;
    final String fThisPluginMetricPath;
    final String fName;
    private IntCounterDataRecorder fExectionCount;
    private IntCounterDataRecorder fErrorCount;
    private LongAverageDataRecorder fExecutionTime;
    private TimestampDataRecorder fLastRunTime;
    private StringEventDataRecorder fSchedule;
    private IntCounterDataRecorder fTimeoutCount;
    protected final IPluginProcessor fProcessor;

    protected EPAPlugin(IPluginProcessor processor, String myKey, String myName) throws IllegalConfigurationException {
        String schedule;
        this.fProcessor = processor;
        this.fFeedback = this.fProcessor.getFeedback();
        this.fLocalizer = this.fProcessor.getLocalizer();
        this.fStateless = -1 != myKey.indexOf(kStatelessSearchKey);
        this.fThisPluginMetricPath = "EPAgent|Plugins|" + myName;
        this.fModule = new Module(EPAgent.kModule.toString() + " " + myName);
        this.fName = myName;
        if (this.isStateless()) {
            schedule = this.fProcessor.getProperties().getProperty(myKey + kScheduleSubKey);
            String delayString = this.fProcessor.getProperties().getProperty(myKey + kDelaySubKey);
            if (null != schedule && null != delayString) {
                String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("stateless_plugin_both_types_1P", this.getName());
                throw new IllegalConfigurationException(s);
            }
            if (null != schedule) {
                this.fCronSchedule = schedule;
            } else if (null != delayString) {
                int delay;
                delayString = delayString.trim();
                try {
                    delay = Integer.parseInt(delayString);
                    if (delay < 1) {
                        throw new NumberFormatException(String.valueOf(delay));
                    }
                }
                catch (NumberFormatException e) {
                    String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("invalid_delay_2P", delayString, this.getName());
                    throw new IllegalConfigurationException(s);
                }
                this.fInterval = delay * 1000;
            } else {
                String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("need_schedule_or_delay_1P", this.getName());
                throw new IllegalConfigurationException(s);
            }
        }
        try {
            this.fExectionCount = DataRecorderFactory.createIntCounterDataRecorder(this.fThisPluginMetricPath + ":Run Count");
            this.fErrorCount = DataRecorderFactory.createIntCounterDataRecorder(this.fThisPluginMetricPath + ":Error Count");
            this.fExecutionTime = DataRecorderFactory.createLongAverageDataRecorder(this.fThisPluginMetricPath + ":Response Time (ms)");
            this.fLastRunTime = DataRecorderFactory.createTimestampDataRecorder(this.fThisPluginMetricPath + ":Last Run Time");
            this.fSchedule = DataRecorderFactory.createStringEventDataRecorder(this.fThisPluginMetricPath + ":Schedule");
            schedule = this.isStateless() ? (null == this.fCronSchedule ? String.valueOf(this.fInterval) : this.fCronSchedule) : "stateful";
            this.fSchedule.recordDataPoint(schedule);
            if (this.isStateless()) {
                this.fTimeoutCount = DataRecorderFactory.createIntCounterDataRecorder(this.fThisPluginMetricPath + ":Timeout Count");
            }
        }
        catch (IllegalMetricNameException e) {
            throw new IllegalConfigurationException(e);
        }
    }

    @Override
    public void run() {
        String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("starting_plugin_1P", this.getName());
        this.fFeedback.info(this.fModule, s);
        if (!this.isStateless()) {
            this.runForever();
        } else if (this.fProcessor.getConfig().detectStalledPlugins()) {
            int timeout = this.fProcessor.getConfig().getPluginTimeout();
            this.runOnceTimed(timeout);
        } else {
            this.runPlugin();
        }
    }

    private void runOnceTimed(long limit) {
        try {
            new TimedCallable((Callable)this, limit).call();
        }
        catch (TimeoutException t) {
            this.fTimeoutCount.add(1);
            String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("stateless_plugin_timeout_1P", this.getName());
            this.fFeedback.error(this.fModule, s);
        }
        catch (Throwable t) {
            this.fErrorCount.add(1);
            String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("stateless_plugin_error_1P", this.getName());
            this.fFeedback.error(this.fModule, s, t);
        }
    }

    public Object call() {
        this.runPlugin();
        return null;
    }

    private void runPlugin() {
        long start = System.currentTimeMillis();
        try {
            this.fLastRunTime.recordTimestamp(start);
        }
        catch (IllegalValueException illegalValueException) {
            // empty catch block
        }
        this.fExectionCount.add(1);
        try {
            this.doRunPlugin();
        }
        catch (InterruptedException t) {
            this.fErrorCount.add(1);
            this.fFeedback.debug(this.fModule, "Plugin: " + this.getName() + " got: " + t.toString() + " due to timeout");
        }
        catch (Throwable t) {
            this.fErrorCount.add(1);
            String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("stateless_plugin_error_1P", this.getName());
            this.fFeedback.error(this.fModule, s, t);
        }
        long duration = System.currentTimeMillis() - start;
        this.fExecutionTime.recordDataPoint(duration);
    }

    private void runForever() {
        while (true) {
            long start = System.currentTimeMillis();
            try {
                this.fLastRunTime.recordTimestamp(start);
                this.fExectionCount.add(1);
                this.doRunPlugin();
            }
            catch (InterruptedException ie) {
                if (ie.getMessage().equalsIgnoreCase("EPAgentSubProcessDestroyed")) {
                    break;
                }
            }
            catch (Throwable ie) {
                // empty catch block
            }
            String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("stateful_plugin_quit_1P", this.getName());
            this.fFeedback.error(this.fModule, s);
            this.fErrorCount.add(1);
            long duration = System.currentTimeMillis() - start;
            this.fExecutionTime.recordDataPoint(duration);
            long runTime = System.currentTimeMillis() - start;
            long delayTime = 30000L;
            if (runTime < delayTime) {
                try {
                    Thread.sleep(delayTime - runTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("stateful_plugin_restart_1P", this.getName());
            this.fFeedback.error(s);
        }
    }

    protected abstract void doRunPlugin() throws InterruptedException;

    public boolean isStateless() {
        return this.fStateless;
    }

    public int getInterval() {
        return this.fInterval;
    }

    public String getSchedule() {
        return this.fCronSchedule;
    }

    public String getName() {
        return this.fName;
    }

    protected static String[] QuotedStringToStringArray(String quotedString) {
        Vector<String> temp = new Vector<String>();
        StreamTokenizer st = new StreamTokenizer(new StringReader(quotedString));
        st.resetSyntax();
        st.wordChars(33, 255);
        st.whitespaceChars(0, 32);
        st.quoteChar(34);
        try {
            while (-1 != st.nextToken()) {
                temp.add(st.sval);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String[] result = new String[temp.size()];
        temp.toArray(result);
        return result;
    }
}

