/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent.http;

import com.wily.introscope.epagent.http.HttpServer;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LegacyServlet
extends HttpServlet {
    private static final String QNAME = "metricName";
    private static final String QTYPE = "metricType";
    private static final String QVAL = "metricValue";

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendError(403);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        long start = System.currentTimeMillis();
        Map params = req.getParameterMap();
        if (!"/".equals(req.getRequestURI())) {
            res.sendError(404);
            return;
        }
        if (this.hasMetricParams(params)) {
            try {
                HttpServer.recordMetric(((String[])params.get(QNAME))[0], ((String[])params.get(QTYPE))[0], ((String[])params.get(QVAL))[0], null);
                res.getWriter().append("metric sent successfully");
                res.setStatus(200);
            }
            catch (Exception ex) {
                res.sendError(400, "Metric error: " + ex.toString());
            }
        } else {
            res.sendError(400, "Invalid/unsupported query string");
        }
        HttpServer.recordHit(System.currentTimeMillis() - start);
    }

    private boolean hasMetricParams(Map<String, String[]> params) {
        return params.size() == 3 && params.containsKey(QNAME) && params.get(QNAME).length == 1 && params.containsKey(QTYPE) && params.get(QTYPE).length == 1 && params.containsKey(QVAL) && params.get(QVAL).length == 1;
    }
}

