/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.external.biz.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.bizdef.BizDefAdministrator;
import com.wily.introscope.agent.external.biz.trace.BtBaseTracer;
import com.wily.introscope.agent.external.biz.util.MutableInteger;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.util.properties.AttributeListing;

public class BtLatencyTracer
extends BtBaseTracer {
    private static ThreadLocal<MutableInteger> stackDepthLocal = new ThreadLocal<MutableInteger>(){

        @Override
        public MutableInteger initialValue() {
            return new MutableInteger(0);
        }
    };

    public BtLatencyTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected MutableInteger getStackDepth() {
        return stackDepthLocal.get();
    }

    private void updateLatencyTimeMetric(InvocationData data) {
        StringBuilder sb;
        long timeStamp = -1L;
        SharedCrossProcessData scd = data.getSharedCrossProcessData();
        if (scd != null) {
            try {
                String timestampString = scd.getStringParamIn("CallerTimestamp");
                if (timestampString != null) {
                    timeStamp = Long.parseLong(timestampString);
                }
            }
            catch (NumberFormatException timestampString) {
                // empty catch block
            }
        }
        if (timeStamp > 0L && (sb = BizDefAdministrator.createBtMetricBuilder(data)) != null) {
            int latency = (int)(System.currentTimeMillis() - timeStamp);
            sb.append(this.getFormattedName());
            IIntegerAverageDataAccumulator counter = this.dataAccumulatorfactory.safeGetBizTrxIntegerAverageDataAccumulator(sb.toString());
            counter.IIntegerAggregatingDataAccumulator_recordDataPoint(latency);
        }
    }

    @Override
    protected void updateBtMetricAtStart(InvocationData data) {
        this.updateLatencyTimeMetric(data);
    }

    @Override
    protected void updateBtMetricAtFinish(InvocationData data) {
    }
}

