/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.dataresolver;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpDataResolver;
import com.wily.introscope.agent.trace.backend.http.helper.HttpResponseHelper;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.utilities.UrlUtilities;
import com.wily.util.feedback.Module;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;

public class HttpURLConnectionDataResolver
implements HttpDataResolver {
    private static Module module = new Module("HttpURLConnectionDataResolver");
    private static final HttpDataResolver instance = new HttpURLConnectionDataResolver();

    protected HttpURLConnectionDataResolver() {
    }

    public static HttpDataResolver getInstance() {
        return instance;
    }

    @Override
    public URI getUri(IAgent agent, InvocationData data) {
        try {
            HttpURLConnection connection = (HttpURLConnection)data.getInvocationObject();
            URL url = connection.getURL();
            if (url != null) {
                String path = url.getPath();
                if (path != null && !path.isEmpty() && !path.startsWith("/")) {
                    if (agent.IAgent_getModuleFeedback().isDebugEnabled()) {
                        agent.IAgent_getModuleFeedback().debug("Path had no leading slash - would cause unknown host: " + url.toString());
                    }
                    url = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/{invalid}");
                }
                return UrlUtilities.encodeValidURI(agent, url);
            }
        }
        catch (Exception e) {
            agent.IAgent_getModuleFeedback().error(module, "getURI(), Unable to get URL:" + e);
            agent.IAgent_getModuleFeedback().error((Throwable)e);
        }
        return BackendProtocolsConstants.UNKNOWN_URI;
    }

    @Override
    public String getHttpMethod(IAgent agent, InvocationData data) {
        try {
            HttpURLConnection connection = (HttpURLConnection)data.getInvocationObject();
            return connection.getRequestMethod();
        }
        catch (Exception e) {
            agent.IAgent_getModuleFeedback().error(module, "getRequestMethod(), Unable to get method:" + e);
            agent.IAgent_getModuleFeedback().error((Throwable)e);
            return null;
        }
    }

    @Override
    public int getHttpStatusCode(IAgent agent, InvocationData data) {
        try {
            boolean expected;
            if (data.hasInvocationThrownException() && (expected = this.isExpectedException(data.getInvocationThrownException()))) {
                return -1;
            }
            HttpURLConnection connection = (HttpURLConnection)data.getInvocationObject();
            int responseCode = HttpResponseHelper.getResponseCode(connection);
            return responseCode;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getHttpStatusCode() Unable to get response code: " + t.toString());
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return -1;
        }
    }

    @Override
    public String getHttpStatusMessage(IAgent agent, InvocationData data) {
        try {
            boolean expected;
            if (data.hasInvocationThrownException() && (expected = this.isExpectedException(data.getInvocationThrownException()))) {
                return null;
            }
            HttpURLConnection connection = (HttpURLConnection)data.getInvocationObject();
            String responseMessage = HttpResponseHelper.getResponseMessage(connection);
            return responseMessage;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getHttpStatusMessage() Unable to get response status message: " + t.toString());
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }

    protected boolean isExpectedException(Throwable exception) {
        return exception.getClass() == UnknownHostException.class || exception.getClass() == ConnectException.class;
    }
}

