/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.helper;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.net.URL;

public class HttpResponseHelper {
    private static IWeakIdentityMap httpURLConnectionVsResponseHelper = null;
    private volatile int responseCode;
    private volatile String responseMessage;
    private volatile boolean backendCalledForThisConnection;
    private volatile URL url = null;

    private void setUrl(URL url) {
        this.url = url;
    }

    public static URL getURL(Object urlConnection) {
        HttpResponseHelper httpResponseHelper = (HttpResponseHelper)httpURLConnectionVsResponseHelper.getWeak(urlConnection);
        if (httpResponseHelper == null || httpResponseHelper.url == null) {
            return null;
        }
        return httpResponseHelper.url;
    }

    public static int getResponseCode(Object urlConnection) {
        HttpResponseHelper httpResponseHelper = (HttpResponseHelper)httpURLConnectionVsResponseHelper.getWeak(urlConnection);
        if (httpResponseHelper == null || httpResponseHelper.responseCode == 0) {
            return -1;
        }
        return httpResponseHelper.responseCode;
    }

    private void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public static String getResponseMessage(Object urlConnection) {
        HttpResponseHelper httpResponseHelper = (HttpResponseHelper)httpURLConnectionVsResponseHelper.getWeak(urlConnection);
        if (httpResponseHelper == null) {
            return "Unknown";
        }
        return httpResponseHelper.responseMessage;
    }

    public static boolean getBackendCalledAttribute(Object urlConnection) {
        HttpResponseHelper httpResponseHelper = (HttpResponseHelper)httpURLConnectionVsResponseHelper.getWeak(urlConnection);
        if (httpResponseHelper == null) {
            return false;
        }
        return httpResponseHelper.backendCalledForThisConnection;
    }

    private void setResponseMessage(String responseMsg) {
        this.responseMessage = responseMsg;
    }

    public static void putResponseCode(Object urlConnection, int responseCode, IModuleFeedbackChannel logger) {
        HttpResponseHelper httpResponseHelper = (HttpResponseHelper)httpURLConnectionVsResponseHelper.getWeak(urlConnection);
        if (httpResponseHelper == null) {
            httpResponseHelper = new HttpResponseHelper();
            httpURLConnectionVsResponseHelper.putWeak(urlConnection, (Object)httpResponseHelper);
        }
        httpResponseHelper.setResponseCode(responseCode);
    }

    public static void setBackendCalledAttribute(Object urlConnection, IModuleFeedbackChannel logger) {
        HttpResponseHelper httpResponseHelper = (HttpResponseHelper)httpURLConnectionVsResponseHelper.getWeak(urlConnection);
        if (httpResponseHelper == null) {
            httpResponseHelper = new HttpResponseHelper();
            httpURLConnectionVsResponseHelper.putWeak(urlConnection, (Object)httpResponseHelper);
        }
        httpResponseHelper.backendCalledForThisConnection = true;
    }

    public static void putResponseMessage(Object urlConnection, String responseMsg, IModuleFeedbackChannel logger) {
        HttpResponseHelper httpResponseHelper = (HttpResponseHelper)httpURLConnectionVsResponseHelper.getWeak(urlConnection);
        if (httpResponseHelper == null) {
            httpResponseHelper = new HttpResponseHelper();
            httpURLConnectionVsResponseHelper.putWeak(urlConnection, (Object)httpResponseHelper);
        }
        httpResponseHelper.setResponseMessage(responseMsg);
    }

    public static void putURL(Object response, URL url, IModuleFeedbackChannel logger) {
        HttpResponseHelper httpResponseHelper = (HttpResponseHelper)httpURLConnectionVsResponseHelper.getWeak(response);
        if (httpResponseHelper == null) {
            httpResponseHelper = new HttpResponseHelper();
            httpURLConnectionVsResponseHelper.putWeak(response, (Object)httpResponseHelper);
        }
        if (httpResponseHelper.url == null) {
            httpResponseHelper.setUrl(url);
        }
    }

    static {
        IAgent agent = null;
        try {
            agent = AgentShim.getAgent();
            httpURLConnectionVsResponseHelper = agent.IAgent_getConcurrentMapFactory().getConcurrentCappedWeakIdentityMap("httpURLConnectionToStatusInfo");
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            // empty catch block
        }
    }
}

