/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpDataResolver;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpURLConnectionDataResolver;
import com.wily.introscope.agent.trace.backend.http.nameformatter.BaseURINameFormatter;
import com.wily.introscope.agent.trace.utilities.UrlUtilities;
import com.wily.util.feedback.Module;
import java.net.URI;

public class HttpURLConnectionNameFormatter
extends BaseURINameFormatter {
    private static Module module = new Module("HttpURLConnectionNameFormatter");
    private static String defaultType = "HttpURLConnection";

    public HttpURLConnectionNameFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    public String getType(InvocationData data) {
        return defaultType;
    }

    @Override
    public HttpDataResolver getURIResolver() {
        return HttpURLConnectionDataResolver.getInstance();
    }

    @Override
    protected String getRawPath(URI url) {
        String path = super.getRawPath(url);
        if (path != null && !path.isEmpty()) {
            return UrlUtilities.decodeSpecialChars(path);
        }
        return path;
    }

    @Override
    protected String getRawQuery(URI url) {
        String query = super.getRawQuery(url);
        if (query != null && !query.isEmpty()) {
            return UrlUtilities.decodeSpecialChars(query);
        }
        return query;
    }

    @Override
    protected String getHost(URI url) {
        int index;
        String authority;
        String host = super.getHost(url);
        if (host == null && (authority = url.getRawAuthority()) != null && !authority.isEmpty() && (index = (authority = UrlUtilities.decodeSpecialChars(authority)).lastIndexOf("]")) != -1) {
            host = authority.substring(0, index + 1);
        }
        return host;
    }
}

