/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpDataResolver;
import com.wily.introscope.agent.trace.backend.http.dataresolver.SpringHttpClientDataResolver;
import com.wily.introscope.agent.trace.backend.http.helper.SpringHttpClientTracerHelper;
import com.wily.introscope.agent.trace.backend.http.tracer.BaseHttpBackendTracer;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class SpringBackendTracer
extends BaseHttpBackendTracer {
    private static Module module = new Module("SpringBackendTracer");

    public SpringBackendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object tracedObject) {
        super(agent, parameters, probe, tracedObject);
    }

    @Override
    protected HttpDataResolver getDataResolver() {
        return SpringHttpClientDataResolver.getInstance();
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (SpringHttpClientTracerHelper.startBackendTrace(data, this.feedback)) {
            if (this.feedback.isDebugEnabled(module)) {
                this.feedback.debug(module, "ITracer_startTrace - Starting a BACKEND Trace");
            }
            super.ITracer_startTrace(tracerIndex, data);
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (SpringHttpClientTracerHelper.backendTraceStarted(data)) {
            if (this.feedback.isDebugEnabled(module)) {
                this.feedback.debug(module, "ITracer_finishTrace - Finishing a BACKEND Trace");
            }
            super.ITracer_finishTrace(tracerIndex, data);
        }
    }
}

