/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.apmservices.client.service;

import com.ca.apm.agent.apmservices.client.api.APMServicesClientAPI;
import com.ca.apm.agent.apmservices.client.api.JarvisServiceAPI;
import com.ca.apm.agent.apmservices.client.api.MetadataServiceAPI;
import com.ca.apm.agent.apmservices.client.api.NASSServiceAPI;
import com.ca.apm.agent.apmservices.client.api.TASServiceAPI;
import com.ca.apm.agent.apmservices.client.api.TracestoreServiceAPI;
import com.ca.apm.agent.apmservices.client.nass.metricbatch.model.MetricData;
import com.ca.apm.agent.apmservices.client.nass.metricbatch.model.MetricRequest;
import com.ca.apm.agent.apmservices.client.service.JarvisService;
import com.ca.apm.agent.apmservices.client.service.MetadataService;
import com.ca.apm.agent.apmservices.client.service.NASSService;
import com.ca.apm.agent.apmservices.client.service.TASService;
import com.ca.apm.agent.apmservices.client.service.TracestoreService;
import com.ca.apm.agent.apmservices.client.sustainability.APMServicesSustainability;
import com.ca.apm.agent.apmservices.client.sustainability.SustainabilityEvent;
import com.ca.apm.agent.apmservices.client.utils.APMServicesConnection;
import com.ca.apm.tracestore.api.entities.TraceData;
import com.wily.introscope.agent.IAgent;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class APMServicesClientAPIService
implements APMServicesClientAPI {
    private APMServicesConnection connection;
    private MetadataServiceAPI metadataServiceAPI;
    private NASSServiceAPI nassServiceAPI;
    private TASServiceAPI tasServiceAPI;
    private TracestoreServiceAPI tracestoreServiceAPI;
    private JarvisServiceAPI jarvisServiceAPI;
    private String extensionName;

    public APMServicesClientAPIService(IAgent agent, String extensionName) {
        this.connection = new APMServicesConnection(agent);
        this.metadataServiceAPI = new MetadataService(agent, this.connection, extensionName);
        this.nassServiceAPI = new NASSService(agent, this.connection, this.metadataServiceAPI, extensionName);
        this.tasServiceAPI = new TASService(agent, this.connection);
        this.tracestoreServiceAPI = new TracestoreService(agent, this.connection);
        this.jarvisServiceAPI = new JarvisService(agent, this.connection, extensionName);
        this.extensionName = extensionName;
        if (!"APMServicesSustainability".equals(extensionName) && !extensionName.equals("dummy agent")) {
            APMServicesSustainability.init(agent);
        }
    }

    @Override
    public Integer sendMetric(MetricRequest metricRequest) {
        return this.nassServiceAPI.sendMetric(metricRequest);
    }

    @Override
    public void sendMetricAsync(MetricRequest request) {
        this.nassServiceAPI.sendMetricAsync(request);
    }

    @Override
    public Integer sendBatchMetric(List<MetricRequest> metricRequestList) {
        return this.nassServiceAPI.sendBatchMetric(metricRequestList);
    }

    @Override
    public void sendBatchMetricAsync(List<MetricRequest> request) {
        this.nassServiceAPI.sendBatchMetric(request);
    }

    @Override
    public void registerMetric(Collection<MetricData> metricToRegister) {
        this.metadataServiceAPI.registerMetric(metricToRegister);
    }

    @Override
    public void storeGraph() {
        this.tasServiceAPI.storeGraph();
    }

    @Override
    public void configureGraph() {
        this.tasServiceAPI.configureGraph();
    }

    @Override
    public void processTrace(List<TraceData> traceData) {
        this.tracestoreServiceAPI.processTrace(traceData);
    }

    @Override
    public void processEvent(Collection<Map<String, String>> events) {
        this.jarvisServiceAPI.processEvent(events);
    }

    @Override
    public void processAlarm(Collection<Map<String, String>> alarms) {
        this.jarvisServiceAPI.processAlarm(alarms);
    }

    @Override
    public void processSustainabilityEventsAsync(Collection<SustainabilityEvent> events) {
        this.jarvisServiceAPI.processSustainabilityEventsAsync(events);
    }

    @Override
    public void processSustainabilityEventAsync(SustainabilityEvent event) {
        this.jarvisServiceAPI.processSustainabilityEventAsync(event);
    }
}

