/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.ResultSetToSQLMappingTracer;
import com.wily.introscope.agent.sqlagent.SQLAgentConfiguration;
import com.wily.introscope.agent.sqlagent.hc2.StatementToConnectionMappingTracer;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.APureMapTransactionElement;
import com.wily.introscope.agent.trace.cas.APureSetTransactionElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElementProvider;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.trace.hc2.AImmutableBlameComponent;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.jdbc.SQLNameFormatterUtilities;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.properties.AttributeListing;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public final class ResultSetCloseTimer
extends ASingleInstanceTracerFactory
implements ITransactionElementProvider {
    private final String kNameKeyPerformance = this.getParameter("name");
    static final Object kResultSetTransaction = new Object();
    public static final int kDefaultStringBufferSize = 200;
    private final SQLAgentConfiguration fConfiguration;
    private boolean bShutOff;
    private static ThreadLocal reentrancyMonitor = new ThreadLocal(){

        protected Object initialValue() {
            return new int[]{0};
        }
    };

    public ResultSetCloseTimer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fConfiguration = SQLAgentConfiguration.getInstance(agent);
        this.bShutOff = this.fConfiguration.isMetricsTurnedOff() || this.fConfiguration.shouldReportOnlyARTMetric();
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kInstance;
    }

    public final boolean ITracerFactory_isShutoff() {
        return this.bShutOff;
    }

    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
        int[] depth = (int[])reentrancyMonitor.get();
        depth[0] = depth[0] + 1;
    }

    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        int[] depth;
        (depth = (int[])ResultSetCloseTimer.reentrancyMonitor.get())[0] = depth[0] - 1;
        if ((depth = (int[])ResultSetCloseTimer.reentrancyMonitor.get())[0] == 0) {
            long startTime;
            long endTime = data.getWallClockFinishTime();
            ResultSet tracedObject = (ResultSet)data.getInvocationObject();
            ResultSetToSQLMappingTracer.ResultSetCreationRecord recordBean = ResultSetToSQLMappingTracer.getRecord(tracedObject);
            if (recordBean != null && (startTime = recordBean.getStartTime()) > 0L && startTime <= endTime) {
                ITransactionElement cursor;
                long diff = endTime - startTime;
                int elapsedTime = (int)diff;
                ABlameComponent key = null;
                String sql = recordBean.getSQL();
                Statement stmt = recordBean.getStatement();
                if (sql != null) {
                    if (stmt != null) {
                        Connection conn = StatementToConnectionMappingTracer.getConnection(stmt);
                        if (conn != null) {
                            try {
                                Object URL2 = data.getFromTransactionCache((Object)conn);
                                if (URL2 == null) {
                                    URL2 = SQLNameFormatterUtilities.getSafeCachedURL(this.getAgent().IAgent_getModuleFeedback(), conn);
                                    data.putInTransactionCache((Object)conn, URL2);
                                }
                                key = ABlameComponent.getInstance((Object)URL2, (Object)sql, (Object)this.kNameKeyPerformance);
                            }
                            catch (ThreadDeath td) {
                                throw td;
                            }
                            catch (Throwable t) {
                                key = AImmutableBlameComponent.getImmutableInstance((Object)sql, (Object)this.kNameKeyPerformance);
                            }
                        } else {
                            key = AImmutableBlameComponent.getImmutableInstance((Object)sql, (Object)this.kNameKeyPerformance);
                        }
                    } else {
                        key = AImmutableBlameComponent.getImmutableInstance((Object)sql, (Object)this.kNameKeyPerformance);
                    }
                }
                if (key == null) {
                    return;
                }
                WilyTransactionStructure structure = WilyTransactionStructure.getInstance();
                ResultSetTransactionElement cursor2 = (ResultSetTransactionElement)structure.submitNextStartTransaction((Object)key, cursor = structure.submitStartTransactionNoBlameTracer(kResultSetTransaction, tracerIndex, (IStackElement)data, (ITransactionElementProvider)this), tracerIndex, (IStackElement)data, (ITransactionElementProvider)this);
                if (cursor2 == null) {
                    return;
                }
                IRepository resultsetSds = cursor2.getRepository();
                int hashcode = data.hashCode();
                resultsetSds.update(BlamePointTracer.getUpdater(), (long)elapsedTime, endTime, hashcode);
                cursor2.setAgentFeatureIndicant(this.getAgentComponent());
            }
        }
    }

    protected AgentMetric createTimerMetric(String formattedMetricName) {
        int metricType = 1025;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType((IAgent)this.getAgent(), (String)formattedMetricName, (int)metricType, (String)"Invalid Names:Invalid name given for an integer duration metric");
        return metric;
    }

    public ITransactionElement getElement(Object key, ITransactionElement parent) {
        return this.getElementOnStartTrace(key, 0, null, parent);
    }

    public ITransactionElement getElement(Object key, ITransactionElement parent, InvocationData data, boolean isStartTrace) {
        IRepository resultsetSds;
        if (key == kResultSetTransaction) {
            return new APureSetTransactionElement(parent, isStartTrace){

                public void notifyPublished() {
                }

                public void notifyRemoved() {
                    this.invalidate();
                }
            };
        }
        if (data == null) {
            return new ResultSetTransactionElement(parent, isStartTrace);
        }
        ResultSetTransactionElement result = new ResultSetTransactionElement(parent, isStartTrace);
        String path = this.formatParameterizedName(data);
        String metricName = path + ":" + "Average Result Processing Time (ms)";
        AgentMetric resultsetMetric = this.createTimerMetric(metricName);
        IRepository sds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)resultsetMetric, (IRepository)(resultsetSds = BlamePointTracer.getAverageMetricRepository()));
        if (sds != null) {
            resultsetSds = sds;
        }
        result.setRepository(resultsetSds);
        return result;
    }

    public ITransactionElement getElementOnStartTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
        return this.getElement(key, parent, (InvocationData)data, true);
    }

    public ITransactionElement getElementOnEndTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
        return this.getElement(key, parent, (InvocationData)data, false);
    }

    static class ResultSetTransactionElement
    extends APureMapTransactionElement {
        IRepository rep;

        public ResultSetTransactionElement(ITransactionElement parent, boolean isStartTrace) {
            super(parent, isStartTrace);
        }

        public void setRepository(IRepository resultsetSds) {
            this.rep = resultsetSds;
        }

        public IRepository getRepository() {
            return this.rep;
        }

        public void notifyPublished() {
            WilyTransactionStructure.addTransactionElementReferrer((IRepository)this.rep, (ITransactionElement)this);
        }

        public void notifyRemoved() {
            this.invalidate();
            WilyTransactionStructure.removeTransactionElementReferrer((IRepository)this.rep, (ITransactionElement)this);
        }
    }
}

