/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.SQLAgentConfiguration;
import com.wily.introscope.agent.sqlagent.StatementToSQLMappingTracer;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IMetricUpdater;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElementProvider;
import com.wily.introscope.agent.trace.cas.ITransactionInstanceProvider;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.trace.hc2.AImmutableBlameComponent;
import com.wily.introscope.agent.trace.hc2.AverageMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.properties.AttributeListing;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SQLStatementBlamePointTracer
extends BlamePointTracer
implements IInvocationDataParameterCallback {
    public static final String kSQLAgentRawSQL = "SQL:";
    private static final ABlameComponent kNullKey = AImmutableBlameComponent.getImmutableInstance((Object)"Null");
    private static final String kSQLAgentTraceOff = "com.wily.introscope.agent.sqlagent.ttoff";
    private SQLAgentConfiguration fSQLAgentConfig;
    private final IExecuteSQL kExecutor;
    final int fSQLAgentComponent;

    public SQLStatementBlamePointTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fSQLAgentConfig = SQLAgentConfiguration.getInstance(agent);
        this.fSQLAgentComponent = this.getAgentComponent();
        this.kExecutor = this.isDoingTransactionTraces() ? new ExecutionWithTransactionTrace(this) : new ExecutionWithoutTransactionTrace(this);
    }

    private boolean isDoingTransactionTraces() {
        return !this.fSQLAgentConfig.isTracesTurnedOff();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        super.ITracer_startTrace(tracerIndex, data);
        if (this.fSQLAgentConfig.shouldIncludeRawSQL() && !data.isParameterCallbackInitialized()) {
            data.setParameterCallback((IInvocationDataParameterCallback)this);
        }
    }

    protected void doStartBlamePointTrace(int tracerIndex, InvocationData data) {
        if (data.getCursor() != null) {
            this.kExecutor.executeSQLStartTrace(tracerIndex, data);
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        boolean isAborted = data.isTransactionAborted();
        if (!isAborted) {
            if (data.getCursor() != null) {
                this.kExecutor.executeSQLEndTrace(tracerIndex, data);
            }
        } else {
            this.doOnAbortedTransactionEndTrace(tracerIndex, (IStackElement)data);
        }
    }

    protected IBlameComponent getBlameComponent(int tracerIndex, InvocationData data) {
        if (this.fShouldUseComputedBlameKey) {
            return kNullKey;
        }
        return super.getBlameComponent(tracerIndex, data);
    }

    protected WilyTransactionElement constructTransactionElement(Object key, String metricName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation probeInformation) {
        IRepository concurrentSds = null;
        IRepository timerSds = null;
        IRepository stallSds = null;
        IRepository errorsSds = null;
        IRepository perIntervalSds = null;
        HashMap<IRepository, AgentMetric[]> metrics = null;
        if (!this.fSQLAgentConfig.isMetricsTurnedOff()) {
            WilyTransactionStructure structure = WilyTransactionStructure.getInstance();
            boolean hasContextualMetricss = this.computeHasContextualMetrics();
            if (hasContextualMetricss) {
                metrics = new HashMap<IRepository, AgentMetric[]>(4);
            }
            ArrayList<AgentMetric> metricsForGrouping = new ArrayList<AgentMetric>(4);
            AgentMetric[] timerMetric = this.createTimerMetric(this.getTimerMetricName(metricName));
            timerSds = this.getSharedRepository((ISharedElement)AverageMetricGathererWrapper.getFactory((boolean)true), this.fNumberOfStripes);
            if (hasContextualMetricss) {
                metrics.put(timerSds, timerMetric);
            } else {
                timerSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)new AAgentMetricArray(timerMetric), (IRepository)timerSds);
            }
            metricsForGrouping.add(timerMetric[0]);
            if (!this.fSQLAgentConfig.shouldReportOnlyARTMetric()) {
                AgentMetric[] concurrentMetric = this.createConcurrentInvocationMetric(this.getConcurrentInvocationMetricName(metricName));
                concurrentSds = this.getSharedRepositoryNoSharedStructure(false);
                concurrentSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)new AAgentMetricArray(concurrentMetric), (IRepository)concurrentSds);
                metricsForGrouping.add(concurrentMetric[0]);
                AgentMetric[] perIntervalMetric = this.createPerIntervalMetric(this.getPerIntervalMetricName(metricName));
                perIntervalSds = this.getSharedRepository(true, this.fNumberOfStripes);
                if (hasContextualMetricss) {
                    metrics.put(perIntervalSds, perIntervalMetric);
                } else {
                    perIntervalSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)new AAgentMetricArray(perIntervalMetric), (IRepository)perIntervalSds);
                }
                metricsForGrouping.add(perIntervalMetric[0]);
                if (this.shouldForceStandardBlameMetrics()) {
                    AgentMetric[] stallMetric = this.createStallsMetric(this.getStallsMetricName(metricName));
                    stallSds = this.getSharedRepositoryNoSharedStructure(false);
                    if (hasContextualMetricss) {
                        metrics.put(stallSds, stallMetric);
                    } else {
                        stallSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)new AAgentMetricArray(stallMetric), (IRepository)stallSds);
                    }
                    metricsForGrouping.add(stallMetric[0]);
                    AgentMetric[] errorMetric = this.createErrorsMetric(this.getErrorsMetricName(metricName));
                    errorsSds = this.getSharedRepository(true, this.fNumberOfStripes);
                    if (hasContextualMetricss) {
                        metrics.put(errorsSds, errorMetric);
                    } else {
                        errorsSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)new AAgentMetricArray(errorMetric), (IRepository)errorsSds);
                    }
                    metricsForGrouping.add(errorMetric[0]);
                } else {
                    stallSds = null;
                    errorsSds = null;
                }
            }
            this.getAgent().IAgent_getMetricRecordingAdministrator().addMetricGroup(metricName, metricsForGrouping);
        }
        WilyTransactionElement result = new WilyTransactionElement(key, metricName, this.getBlameStatus(), isStartTrace, parent, previous, start, metrics, timerSds, perIntervalSds, concurrentSds, errorsSds, stallSds, probeInformation, this.subscribeToDownstreamErrors(), this.subscribeToDownstreamStalls(), this.getFilterEnablerBit());
        result.setAgentFeatureIndicant(this.fSQLAgentComponent);
        return result;
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        if (this.fSQLAgentConfig.shouldIncludeRawSQL()) {
            String rawSQL = null;
            Statement stmt = (Statement)data.getInvocationObject();
            if (data.getInvocationParameterCount() > 0) {
                Object rawSQLObj = data.getInvocationParameterAsObject(0);
                if (rawSQLObj != null && rawSQLObj instanceof String) {
                    rawSQL = (String)rawSQLObj;
                }
            } else {
                rawSQL = StatementToSQLMappingTracer.getRawSQL(stmt);
            }
            if (rawSQL != null) {
                parameters.put(kSQLAgentRawSQL, rawSQL);
            }
        }
    }

    public ITransactionElement getElementOnEndTrace(Object key, int tracerIndex, IStackElement dataElement, ITransactionElement parent) {
        InvocationData data = (InvocationData)dataElement;
        WilyTransactionElement result = (WilyTransactionElement)super.getElementOnEndTrace(key, tracerIndex, (IStackElement)data, parent);
        if (this.fSQLAgentComponent == 1) {
            result.setAgentFeatureIndicant(this.fSQLAgentComponent);
        }
        return result;
    }

    private class ExecutionWithoutTransactionTrace
    implements IExecuteSQL {
        ITransactionElementProvider fProvider;
        IMetricUpdater fUpdater;

        public ExecutionWithoutTransactionTrace(SQLStatementBlamePointTracer sqlStatementBlamePointTracer) {
            this.fProvider = sqlStatementBlamePointTracer;
            this.fUpdater = sqlStatementBlamePointTracer;
        }

        @Override
        public final void executeSQLStartTrace(int tracerIndex, InvocationData data) {
            IBlameComponent component = SQLStatementBlamePointTracer.this.getBlameComponent(tracerIndex, data);
            ITransactionElement currentCursor = data.getCursor();
            WilyTransactionStructure.getInstance().submitNextStartTransaction((Object)component, currentCursor, tracerIndex, (IStackElement)data, this.fProvider, this.fUpdater);
        }

        @Override
        public final void executeSQLEndTrace(int tracerIndex, InvocationData data) {
            ITransactionElement currentCursor = data.getCursor();
            currentCursor = WilyTransactionStructure.getInstance().submitNextEndTransaction(WilyTransactionElement.kEndKey, currentCursor, tracerIndex, data, this.fProvider, this.fUpdater, false);
            data.setCursor(currentCursor);
        }
    }

    private class ExecutionWithTransactionTrace
    implements IExecuteSQL {
        SQLStatementBlamePointTracer fParent;

        public ExecutionWithTransactionTrace(SQLStatementBlamePointTracer sqlStatementBlamePointTracer) {
            this.fParent = sqlStatementBlamePointTracer;
        }

        @Override
        public final void executeSQLStartTrace(int tracerIndex, InvocationData data) {
            IBlameComponent component = SQLStatementBlamePointTracer.this.getBlameComponent(tracerIndex, data);
            ITransactionElement currentCursor = data.getCursor();
            WilyTransactionStructure.getInstance().submitNextStartTransaction((Object)component, currentCursor, tracerIndex, (IStackElement)data, (ITransactionElementProvider)this.fParent, (ITransactionInstanceProvider)this.fParent, (IMetricUpdater)this.fParent);
        }

        @Override
        public final void executeSQLEndTrace(int tracerIndex, InvocationData data) {
            ITransactionElement currentCursor = data.getCursor();
            currentCursor = WilyTransactionStructure.getInstance().submitNextEndTransaction((Object)WilyTransactionElement.kEndKey, currentCursor, tracerIndex, (IStackElement)data, (ITransactionElementProvider)this.fParent, (ITransactionInstanceProvider)this.fParent, (IMetricUpdater)this.fParent, false);
            data.setCursor(currentCursor);
        }
    }

    private static interface IExecuteSQL {
        public void executeSQLStartTrace(int var1, InvocationData var2);

        public void executeSQLEndTrace(int var1, InvocationData var2);
    }
}

