/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.jdbc;

import com.wily.introscope.agent.trace.jdbc.ISybaseDBNameFormatter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.text.IStringLocalizer;
import java.lang.reflect.Field;
import java.sql.Connection;

public class SybasePoolFormatter
implements ISybaseDBNameFormatter {
    protected static final Module kModule = new Module("SQLNameFormatterUtilities");

    @Override
    public String format(String inString, Connection conn, IStringLocalizer localizer, IModuleFeedbackChannel feedback) {
        String result = localizer.IStringLocalizer_getLocalizedString("Agent_SQL_Backend_Sybase_Default_Template");
        String host = null;
        String port = null;
        String dbName = null;
        String[] INFO_FIELDS = new String[]{"_currentHostPort", "_dbName"};
        if (conn != null) {
            for (String fieldName : INFO_FIELDS) {
                try {
                    Field field = conn.getClass().getSuperclass().getDeclaredField(fieldName);
                    field.setAccessible(true);
                    Object value = field.get(conn);
                    if (value == null) continue;
                    if (fieldName.equals("_dbName")) {
                        dbName = value.toString();
                        continue;
                    }
                    host = value.toString();
                    if (!host.contains(":")) continue;
                    int separator = host.indexOf(":");
                    port = host.substring(separator + 1);
                    host = host.substring(0, separator);
                }
                catch (SecurityException e) {
                    feedback.error(kModule, "SecurityException: ", (Throwable)e);
                }
                catch (NoSuchFieldException e) {
                    feedback.error(kModule, "NoSuchFieldException: ", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    feedback.error(kModule, "IllegalArgumentException: ", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    feedback.error(kModule, "IllegalAccessException: ", (Throwable)e);
                }
            }
            if (host != null && port != null) {
                result = dbName != null ? localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Sybase_Template", dbName, host, port) : localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Sybase_No_SID_Template", host, port);
            }
        }
        return result;
    }
}

