/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.arf.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.wily.introscope.agent.arf.ArfMap;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;

public class ArfMapDeserializer
implements JsonDeserializer<ArfMap> {
    @Override
    public ArfMap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArfMap arfMap = null;
        try {
            Type type = new TypeToken<Object>(){}.getType();
            Gson gson = new GsonBuilder().create();
            Map testMap = (Map)gson.fromJson(json, type);
            arfMap = this.parseMapData(testMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arfMap;
    }

    private ArfMap parseMapData(Map<String, Object> testMap) throws Exception {
        ArfMap arfMap = null;
        arfMap = new ArfMap();
        Iterator<String> it = testMap.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            Object value = testMap.get(key);
            if (value instanceof String) {
                arfMap.putString(key, (String)value);
                continue;
            }
            if (value instanceof Integer) {
                arfMap.putInteger(key, (Integer)value);
                continue;
            }
            if (value instanceof Long) {
                arfMap.putLong(key, (Long)value);
                continue;
            }
            if (value instanceof Double) {
                double double_value = (Double)value;
                if (double_value <= 2.147483647E9 && double_value >= -2.147483648E9) {
                    arfMap.putInteger(key, (int)double_value);
                    continue;
                }
                if (!(double_value <= 9.223372036854776E18) || !(double_value >= -9.223372036854776E18)) continue;
                arfMap.putLong(key, (long)double_value);
                continue;
            }
            if (value instanceof Boolean) {
                arfMap.putBoolean(key, (Boolean)value);
                continue;
            }
            if (!(value instanceof Map)) continue;
            Map map = (Map)value;
            ArfMap parsedMap = this.parseMapData(map);
            arfMap.putObject(key, parsedMap);
        }
        return arfMap;
    }
}

