/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.service;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.arf.AArfConnection;
import com.wily.introscope.agent.arf.ArfMap;
import com.wily.introscope.agent.arf.ArfMessage;
import com.wily.introscope.agent.service.json.JsonGenerator;
import com.wily.introscope.agent.service.response.AgentVertices;
import com.wily.introscope.agent.service.response.Vertex;
import com.wily.introscope.spec.server.appmap.remotehttp.RemoteHttpCallClient;
import com.wily.introscope.spec.server.appmap.remotehttp.RemoteHttpResponse;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.service.ServiceException;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.SeverityLevel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ProbeAttributeDecorationService {
    public static final String K_ATT_DEC_APM_ACCESS_TOKEN = "attribute.decoration.apm.access.token";
    public static final String ATTRIBUTE_DECORATION_PREFIX = "attribute.decoration.";
    private final String kProbeProcessNameKey = "introscope.remoteagent.probe.process.name";
    private final String kProbeProcessDefaultName = "{type}";
    private final String kProbeAgentNameKey = "introscope.remoteagent.probe.agent.name";
    private final String kProbeAgentDefaultName = "{program}";
    public final String kDefaultAgentNameSystemPropertyKey = "introscope.agent.agentName";
    private final String kAgentCollectorDefaultName = "{collector}";
    private Random rand = new Random();
    private int low = 60;
    private int high = 120;
    private static ProbeAttributeDecorationService instance = new ProbeAttributeDecorationService();

    private ProbeAttributeDecorationService() {
    }

    public static ProbeAttributeDecorationService instance() {
        return instance;
    }

    public void processProbeAttributes(IAgent fAgent, AArfConnection conn, ArfMessage m) {
        try {
            String agentString = this.buildAgentString(fAgent, conn);
            String authString = this.retrieveAuthString(fAgent);
            Map<String, String> topologyAttributes = this.parseAndTransformAttributes(m);
            if (!topologyAttributes.isEmpty()) {
                String agentVertexes = this.getAgentVertexes(fAgent, agentString, authString);
                if (StringUtils.isEmpty(agentVertexes)) {
                    return;
                }
                this.reportAttributes(fAgent, topologyAttributes, this.getVertexIds(agentVertexes));
            }
        }
        catch (Exception e) {
            this.log(fAgent, SeverityLevel.ERROR, "Unable to Process Custom Attributes", e);
        }
    }

    private void log(IAgent fAgent, SeverityLevel severityLevel, String msg, Exception e) {
        IModuleFeedbackChannel feedback = fAgent.IAgent_getModuleFeedback();
        if (feedback == null) {
            return;
        }
        try {
            if (feedback.isLogEnabled(severityLevel, fAgent.IAgent_getModule())) {
                feedback.log(severityLevel, msg, e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String retrieveAuthString(IAgent fAgent) {
        return fAgent.IAgent_getIndexedProperties().getProperty(K_ATT_DEC_APM_ACCESS_TOKEN, "");
    }

    private String buildAgentString(IAgent fAgent, AArfConnection conn) {
        String agentStringFmt = conn.getHost() + "|" + fAgent.IAgent_getIndexedProperties().getProperty("introscope.remoteagent.probe.process.name", "{type}") + "|" + fAgent.IAgent_getIndexedProperties().getProperty("introscope.remoteagent.probe.agent.name", "{program}");
        if (agentStringFmt != null) {
            if (agentStringFmt.indexOf("{type}", 0) >= 0) {
                agentStringFmt = StringUtils.replace(agentStringFmt, "{type}", conn.getProbe());
            }
            if (agentStringFmt.indexOf("{program}", 0) >= 0) {
                agentStringFmt = StringUtils.replace(agentStringFmt, "{program}", conn.getProgram());
            }
            if (agentStringFmt.indexOf("{collector}", 0) >= 0) {
                agentStringFmt = StringUtils.replace(agentStringFmt, "{collector}", fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.agentName", "{program}"));
            }
        }
        return agentStringFmt;
    }

    private String getAgentVertexes(IAgent fAgent, String vertexString, String authorizationString) {
        String responseString = null;
        try {
            JsonGenerator jg = new JsonGenerator();
            jg.writeStartObject();
            jg.writeFieldName("orItems");
            jg.writeStartArray();
            jg.writeStartObject();
            jg.writeFieldName("andItems");
            jg.writeStartArray();
            jg.writeStartObject();
            jg.writeStringField("itemType", "attributeFilter");
            jg.writeStringField("attributeName", "agent");
            jg.writeStringField("attributeOperator", "IN");
            jg.writeFieldName("values");
            jg.writeStartArray();
            jg.writeString(vertexString);
            jg.writeEndArray();
            jg.writeEndObject();
            jg.writeEndArray();
            jg.writeEndObject();
            jg.writeEndArray();
            jg.writeEndObject();
            HashMap<String, String> reqHeaders = new HashMap<String, String>();
            reqHeaders.put("Authorization", "Bearer " + authorizationString);
            for (int retryAttempts = 0; retryAttempts < 4; ++retryAttempts) {
                RemoteHttpResponse ret = new RemoteHttpCallClient(fAgent.IAgent_getIsengardServerConnection().getConnectedServer().getPostOffice()).doPost("/apm/appmap/graph/vertex", jg.toString(), reqHeaders);
                int statusCode = ret.getHttpCode();
                if (200 == statusCode) {
                    responseString = new String(ret.getResponseBody());
                    this.log(fAgent, SeverityLevel.INFO, "Sucessfully received Agent vertex from Enterprise Manager", null);
                    break;
                }
                this.log(fAgent, SeverityLevel.INFO, "Unexpected Error occured while adding Attributes" + statusCode + ", reason = " + ret.getReasonPhrase(), null);
                if (statusCode == 207) {
                    this.log(fAgent, SeverityLevel.INFO, "Successfully added attributes, please remove deleted attributes having null values", null);
                    break;
                }
                if (statusCode / 100 == 4) {
                    this.log(fAgent, SeverityLevel.WARN, "Adding attributes failed", null);
                    break;
                }
                Thread.sleep((this.rand.nextInt(this.high - this.low) + this.low) * 1000);
                this.log(fAgent, SeverityLevel.INFO, "Retrying to add attributes to Agent Vertexes", null);
            }
        }
        catch (IOException e) {
            this.log(fAgent, SeverityLevel.ERROR, "Error while retrieving vertices from APM Team Center: ", e);
        }
        catch (ConnectionException e) {
            this.log(fAgent, SeverityLevel.ERROR, "Error while retrieving vertices from APM Team Center: ", e);
        }
        catch (ServiceException e) {
            this.log(fAgent, SeverityLevel.ERROR, "Error while retrieving vertices from APM Team Center: ", e);
        }
        catch (InterruptedException e) {
            this.log(fAgent, SeverityLevel.ERROR, "Error while retrieving vertices from APM Team Center: ", e);
        }
        return responseString;
    }

    public List<String> getVertexIds(String jsonVertexs) {
        ArrayList<String> vertexID = new ArrayList<String>();
        if (jsonVertexs != null && !jsonVertexs.isEmpty()) {
            try {
                AgentVertices agentVertices = AgentVertices.fromJSON(jsonVertexs);
                if (agentVertices.get_embedded() != null) {
                    Vertex[] vertexes = agentVertices.get_embedded().getVertex();
                    for (int i = 0; i < vertexes.length; ++i) {
                        vertexID.add(vertexes[i].getId());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vertexID;
    }

    private void reportAttributes(IAgent fAgent, Map<String, String> topologyAttributes, List<String> vertexIds) {
        block9: {
            try {
                String authorizationString = this.retrieveAuthString(fAgent);
                if (vertexIds.size() <= 0 || topologyAttributes.size() <= 0) break block9;
                JsonGenerator jg = new JsonGenerator();
                jg.writeStartObject();
                jg.writeFieldName("items");
                jg.writeStartArray();
                for (String id : vertexIds) {
                    jg.writeStartObject();
                    jg.writeStringField("id", id);
                    jg.writeFieldName("attributes");
                    jg.writeStartObject();
                    for (String key : topologyAttributes.keySet()) {
                        String value = topologyAttributes.get(key);
                        if (value != null) {
                            jg.writeFieldName(key);
                            jg.writeStartArray();
                            jg.writeString(topologyAttributes.get(key));
                            jg.writeEndArray();
                            continue;
                        }
                        jg.writeStringField(key, value);
                    }
                    jg.writeEndObject();
                    jg.writeEndObject();
                }
                jg.writeEndArray();
                jg.writeEndObject();
                HashMap<String, String> reqHeaders = new HashMap<String, String>();
                reqHeaders.put("Authorization", "Bearer " + authorizationString);
                this.log(fAgent, SeverityLevel.INFO, "Sending attrbiutes as HTTP patch request to the Enterprsie Manager", null);
                for (int retryAttempts = 0; retryAttempts < 4; ++retryAttempts) {
                    RemoteHttpResponse ret = new RemoteHttpCallClient(fAgent.IAgent_getIsengardServerConnection().getConnectedServer().getPostOffice()).doPatch("/apm/appmap/graph/vertex", jg.toString(), reqHeaders);
                    int statusCode = ret.getHttpCode();
                    if (statusCode == 200) {
                        this.log(fAgent, SeverityLevel.INFO, "Sucessfully added attributes to Agent Vertexes", null);
                        break;
                    }
                    if (statusCode == 207) {
                        this.log(fAgent, SeverityLevel.INFO, "Successfully added attributes, please remove deleted attributes having null values", null);
                        break;
                    }
                    if (statusCode / 100 == 4) {
                        this.log(fAgent, SeverityLevel.INFO, "Adding attributes failed", null);
                        break;
                    }
                    Thread.sleep((this.rand.nextInt(this.high - this.low) + this.low) * 1000);
                    this.log(fAgent, SeverityLevel.INFO, "Retrying to add attributes to Agent Vertexes", null);
                }
            }
            catch (Exception e) {
                this.log(fAgent, SeverityLevel.ERROR, "Adding attributes to Agent Vertex failed", e);
            }
        }
    }

    private Map<String, String> parseAndTransformAttributes(ArfMessage m) {
        HashMap<String, String> customAttributes = new HashMap<String, String>();
        ArfMap attributes = m.getParams();
        Iterator params = attributes.iterator_keys();
        while (params.hasNext()) {
            String attrName = (String)params.next();
            if (!attrName.contains(ATTRIBUTE_DECORATION_PREFIX)) continue;
            customAttributes.put(attrName.replace(ATTRIBUTE_DECORATION_PREFIX, ""), attributes.getString(attrName));
        }
        return customAttributes;
    }
}

