/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.commands;

import com.ca.agent.extensions.dbmon.DBMonCommand;
import com.ca.agent.extensions.dbmon.DBMonException;
import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.ca.agent.extensions.dbmon.entity.DBMonResultSet;
import com.ca.agent.extensions.dbmon.schema.DBMonSQLAttributeMapping;
import com.google.gson.Gson;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class DBMonExecuteAttributeQueryCommand
implements DBMonCommand {
    private IModuleFeedbackChannel logger;
    private Connection conn;
    private DBMonMetricsContext dbContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(DBMonMetricsContext dbContext) throws DBMonException {
        this.dbContext = dbContext;
        this.logger = dbContext.getAgent().IAgent_getModuleFeedback();
        this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Connecting to database...");
        try {
            this.conn = dbContext.initializeConnection();
        }
        catch (Exception exe) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, dbContext.printDbConnectionDetails(), (Throwable)exe);
            return false;
        }
        try {
            for (DBMonSQLAttributeMapping sqlAttributeMapping : dbContext.getDbDetailsSchema().getSqlAttributeMappings()) {
                this.fireAndUpdateAttributes(sqlAttributeMapping);
            }
        }
        finally {
            try {
                if (this.conn != null) {
                    this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Closed Database Connection Successfully...");
                    this.conn.close();
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAndUpdateAttributes(DBMonSQLAttributeMapping sqlAttributeMapping) {
        String query = sqlAttributeMapping.getQuery();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Query to be executed is:" + query);
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery(query);
            DBMonResultSet dbResultSet = new DBMonResultSet();
            this.createResultSetObject(rs, dbResultSet);
            this.dbContext.getDbAttributeResultSet().put(query, dbResultSet);
        }
        catch (Exception exe) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
        }
    }

    private void createResultSetObject(ResultSet rs, DBMonResultSet dbResultSet) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int colCount = meta.getColumnCount();
        while (rs.next()) {
            HashMap<String, String> row = new HashMap<String, String>();
            for (int col = 1; col <= colCount; ++col) {
                Object value = rs.getObject(col);
                if (value == null) continue;
                if (value instanceof Clob) {
                    Clob clobVal = (Clob)value;
                    String strVal = clobVal.getSubString(1L, (int)clobVal.length());
                    row.put(meta.getColumnName(col), strVal);
                    continue;
                }
                row.put(meta.getColumnName(col), value.toString());
            }
            dbResultSet.addToResultSet(row);
        }
        Gson gson = new Gson();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Query output:" + gson.toJson(dbResultSet));
        }
    }
}

