/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.commands;

import com.ca.agent.extensions.dbmon.DBMonAPMMetric;
import com.ca.agent.extensions.dbmon.DBMonCommand;
import com.ca.agent.extensions.dbmon.DBMonException;
import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.ca.agent.extensions.dbmon.entity.DBMonResultSet;
import com.ca.agent.extensions.dbmon.helper.DBMonJsonPathHelper;
import com.ca.agent.extensions.dbmon.helper.FileHelper;
import com.ca.agent.extensions.dbmon.schema.DBMonMetricPath;
import com.ca.agent.extensions.dbmon.schema.DBMonMetrics;
import com.ca.agent.extensions.dbmon.schema.DBMonSQLMetricMapping;
import com.google.gson.Gson;
import com.jayway.jsonpath.Configuration;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DBMonPopulateAPMMetricsCommand
implements DBMonCommand {
    private IModuleFeedbackChannel logger;
    private DBMonMetricsContext dbContext;
    private DBMonJsonPathHelper jsonPathHelper = new DBMonJsonPathHelper();
    private FileHelper fileHelper = new FileHelper();

    @Override
    public boolean execute(DBMonMetricsContext dbContext) throws DBMonException {
        this.dbContext = dbContext;
        this.logger = dbContext.getAgent().IAgent_getModuleFeedback();
        Gson gson = new Gson();
        for (Map.Entry<String, DBMonResultSet> entrySet : dbContext.getDbResultSet().entrySet()) {
            try {
                DBMonResultSet dbMonResultSet = entrySet.getValue();
                String strResultSet = gson.toJson(dbMonResultSet);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Query key:" + entrySet.getKey());
                    this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "result set json object:" + strResultSet);
                }
                Object document = Configuration.defaultConfiguration().jsonProvider().parse(strResultSet);
                for (DBMonSQLMetricMapping sqlMetrics : dbContext.getDbDetailsSchema().getSqlMetricMappings()) {
                    if (!sqlMetrics.getQuery().equals(entrySet.getKey())) continue;
                    this.generateAPMMetric(document, sqlMetrics);
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
        }
        return true;
    }

    private void generateAPMMetric(Object document, DBMonSQLMetricMapping sqlMetrics) {
        for (DBMonMetrics dbMonMetric : sqlMetrics.getMetrics()) {
            if (this.isMetricPathDynamic(dbMonMetric)) {
                this.generateMultipleAPMMetrics(document, dbMonMetric);
                continue;
            }
            this.appendValuesToSingleMetric(document, dbMonMetric);
        }
    }

    private void appendValuesToSingleMetric(Object document, DBMonMetrics dbMonMetric) {
        List<String> metricVals = this.jsonPathHelper.evaluate(document, dbMonMetric.getMetricValue());
        List<DBMonMetricPath> paths = dbMonMetric.getMetricPath();
        ArrayList<String> metricValues = new ArrayList<String>();
        for (int i = 0; i < metricVals.size(); ++i) {
            metricValues.add(metricVals.get(i));
        }
        this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Metric Path:" + paths.get(0).getName());
        this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Metric Type:" + dbMonMetric.getMetricType());
        this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Metric Value:" + ((Object)metricValues).toString());
        if (metricValues.size() == 0) {
            this.dbContext.getApmMetrics().add(new DBMonAPMMetric(paths.get(0).getName(), dbMonMetric.getMetricType(), null));
        } else if (metricValues.size() == 1) {
            this.dbContext.getApmMetrics().add(new DBMonAPMMetric(paths.get(0).getName(), dbMonMetric.getMetricType(), metricValues.get(0)));
        } else {
            this.dbContext.getApmMetrics().add(new DBMonAPMMetric(paths.get(0).getName(), dbMonMetric.getMetricType(), ((Object)metricValues).toString()));
        }
    }

    private void generateMultipleAPMMetrics(Object document, DBMonMetrics dbMonMetric) {
        List<String> metricVals = this.jsonPathHelper.evaluate(document, dbMonMetric.getMetricValue());
        for (int i = 0; i < metricVals.size(); ++i) {
            try {
                String metricPath = this.extractMetricName(document, dbMonMetric, i);
                this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Metric Path:" + metricPath);
                this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Metric Type:" + dbMonMetric.getMetricType());
                this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Metric Value:" + metricVals.get(i));
                this.dbContext.getApmMetrics().add(new DBMonAPMMetric(metricPath, dbMonMetric.getMetricType(), metricVals.get(i)));
                continue;
            }
            catch (DBMonException e) {
                this.logger.debug("Couldn't create metric with name: " + dbMonMetric.getMetricPath() + ", for metricValue: " + metricVals.get(i));
                this.logger.debug((Throwable)e);
            }
        }
    }

    private boolean isMetricPathDynamic(DBMonMetrics dbMonMetric) {
        for (DBMonMetricPath path : dbMonMetric.getMetricPath()) {
            if (!path.containsJsonPath()) continue;
            return true;
        }
        return false;
    }

    private String extractMetricName(Object document, DBMonMetrics dbMonMetric, int index) throws DBMonException {
        StringBuilder metricPath = new StringBuilder();
        for (DBMonMetricPath path : dbMonMetric.getMetricPath()) {
            if (path.containsJsonPath()) {
                String evaluatedPath = this.jsonPathHelper.evaluate(this.logger, document, index, path.getName());
                if (this.fileHelper.ifMetricContainsPath(evaluatedPath = this.replaceWithAlias(evaluatedPath, path))) {
                    metricPath.append(this.fileHelper.extractFileName(evaluatedPath));
                    continue;
                }
                metricPath.append(evaluatedPath);
                continue;
            }
            metricPath.append(path.getName());
        }
        return metricPath.toString();
    }

    private String replaceWithAlias(String evaluatedPath, DBMonMetricPath path) {
        if (path.getFrom() != null && !path.getFrom().isEmpty()) {
            for (int i = 0; i < path.getFrom().size(); ++i) {
                String key = path.getFrom().get(i);
                if (!key.equals(evaluatedPath)) continue;
                return path.getTo().get(i);
            }
        }
        return evaluatedPath;
    }
}

