/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.traces;

import com.ca.agent.extensions.dbmon.entity.query.plan.DBMonQueryPlan;
import com.ca.agent.extensions.dbmon.entity.query.plan.MySqlDBMonQueryPlan;
import com.ca.agent.extensions.dbmon.entity.query.plan.OracleDBMonQueryPlan;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DBMonQueryPlanParserFactory {
    private DBMonQueryPlanParserFactory() {
    }

    public static DBMonQueryPlan getQueryPlanForDB(String dbType, ResultSet rs) throws SQLException {
        DBMonQueryPlan dbMonQueryPlan = null;
        if (dbType.toUpperCase().startsWith("ORACLE")) {
            dbMonQueryPlan = new OracleDBMonQueryPlan(rs).mapResultToPlan();
        } else if (dbType.toUpperCase().startsWith("MYSQL")) {
            dbMonQueryPlan = new MySqlDBMonQueryPlan(rs).mapResultToPlan();
        } else {
            throw new UnsupportedOperationException("QueryPlan snapshots are UnSupported for DatabaseType " + dbType);
        }
        return dbMonQueryPlan;
    }
}

