/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.ACachingImmutableClassMatcher;
import com.wily.introscope.agent.transformer.dynamic.IOldDeepInheritanceHelper;
import com.wily.introscope.agent.transformer.dynamic.ThreadLocalClassHelper;
import com.wily.introscope.api.instrument.DeepInheritanceHelper;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import java.util.HashMap;
import java.util.Map;

public class DGInheritedAnnotationClassMatcher
extends ACachingImmutableClassMatcher {
    private static final Map<String, DGInheritedAnnotationClassMatcher> singleton = new HashMap<String, DGInheritedAnnotationClassMatcher>();
    private final IClassName fAnnotationClassName;
    private final String fRootAnnotationName;
    private final int fRootAnnotationNameIndex;
    private final boolean shallowMatch;
    static final boolean isDIv1 = "premain".equals(System.getProperty("com.wily.introscope.agent.starter")) && "1".equals(System.getProperty("com.wily.introscope.deepInheritance.implementationVersion", "1"));

    private DGInheritedAnnotationClassMatcher(IClassName className) {
        String name = className.getReflectionFriendlyQualifiedNameString();
        if (singleton.containsKey(name)) {
            throw new RuntimeException("Instance already created");
        }
        this.fAnnotationClassName = className;
        this.fRootAnnotationName = this.fAnnotationClassName.getReflectionFriendlyQualifiedNameString();
        this.fRootAnnotationNameIndex = DeepInheritanceHelper.classNameForest.addAndGetID(this.fRootAnnotationName);
        this.shallowMatch = !DeepInheritanceHelper.onlyDeep;
    }

    public static DGInheritedAnnotationClassMatcher getInstance(IClassName className) {
        String name = className.getReflectionFriendlyQualifiedNameString();
        if (!singleton.containsKey(name)) {
            singleton.put(name, new DGInheritedAnnotationClassMatcher(className));
        }
        return singleton.get(name);
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        boolean result;
        if (isDIv1) {
            result = cls.containsAnnotation(this.fAnnotationClassName);
            IOldDeepInheritanceHelper helper = ThreadLocalClassHelper.getDeepInheritanceHelper();
            if (helper != null) {
                if (result) {
                    helper.noticeFoundAnnotationRoot(cls.getClassName(), this.fAnnotationClassName);
                } else {
                    result = helper.addAnnotationShallowMatchRequest(cls, this.fAnnotationClassName);
                }
            }
        } else {
            result = DeepInheritanceHelper.matchForAnnotation((int)this.fRootAnnotationNameIndex, (IModeledClass)cls, (boolean)this.shallowMatch);
        }
        return result;
    }

    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        return false;
    }

    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        return false;
    }

    public IClassName getClassName() {
        return this.fAnnotationClassName;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fAnnotationClassName);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DGInheritedAnnotationClassMatcher) {
            DGInheritedAnnotationClassMatcher m = (DGInheritedAnnotationClassMatcher)obj;
            return this.fAnnotationClassName.equals(m.fAnnotationClassName);
        }
        return false;
    }

    @Override
    public String[] getMatcherKeys() {
        return kAllKeys;
    }
}

