/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.transform.builder.SubscribeToClassTransformationBuilder;
import com.wily.util.validate.ValidationException;

public class SubscribeToClassIfFlaggedDirective
extends ADirective {
    private final FlagName fFlagName;
    private final String fSubscriberPluginName;

    public SubscribeToClassIfFlaggedDirective(String source, int lineNumber, FlagName flagName, String subscriberPluginName) {
        super(source, lineNumber);
        this.fFlagName = flagName;
        this.fSubscriberPluginName = subscriberPluginName;
    }

    public FlagName getFlagName() {
        return this.fFlagName;
    }

    public String getSubscriberPluginName() {
        return this.fSubscriberPluginName;
    }

    @Override
    protected void applyToSettings(CompilerSettingsBuilder builder) throws ValidationException {
        TracerGroupBuilder tracerGroupBuilder = builder.getTracerGroupBuilder(this.getFlagName());
        builder.addTransformation(new SubscribeToClassTransformationBuilder(tracerGroupBuilder, this.getSubscriberPluginName()));
        tracerGroupBuilder.setSource(this.getSource());
    }
}

