/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.mutate.IMethodMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.transform.AEveryMethodTransformation;
import com.wily.diagnos.cmp.transform.builder.CatchExceptionTransformationBuilder;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;

public final class CatchExceptionTransformation
extends AEveryMethodTransformation {
    private final IClassName fInstrumentationClassName;

    public CatchExceptionTransformation(ICompilerLog log, IClassName instrumentationClassName) {
        super(log);
        this.fInstrumentationClassName = instrumentationClassName;
    }

    public IClassName getInstrumentationClassName() {
        return this.fInstrumentationClassName;
    }

    @Override
    protected boolean doShouldProcessClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return true;
    }

    @Override
    protected boolean doShouldMutateMethod(DGCompilerSettings settings, IModeledMethod targetMethod) {
        return targetMethod.hasBytecode();
    }

    @Override
    protected IMutation doGenerateMethodMutation(DGCompilerSettings settings, IMethodMutator mutator, IModeledMethod targetMethod) {
        return mutator.newCatchExceptionMethodMutation(settings, targetMethod, this);
    }

    @Override
    public ITransformationBuilder generateTransformationBuilder(CompilerSettingsBuilder builder) {
        return new CatchExceptionTransformationBuilder();
    }
}

