/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform.builder;

import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.transform.ITransformation;
import com.wily.diagnos.cmp.transform.InsertOnSocketIOTransformation;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.util.classfile.FullyQualifiedMethodName;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import java.util.Map;

public final class InsertOnSocketIOTransformationBuilder
implements ITransformationBuilder {
    private final TracerGroupBuilder fTracerGroupBuilder;
    private final IMethodName fSourceMethod;
    private final FullyQualifiedMethodName fInsertionMethod;

    public InsertOnSocketIOTransformationBuilder(IMethodName sourceMethod, FullyQualifiedMethodName substitutionMethod) {
        this(null, sourceMethod, substitutionMethod);
    }

    public InsertOnSocketIOTransformationBuilder(TracerGroupBuilder tracerGroupBuilder, IMethodName sourceMethod, FullyQualifiedMethodName insertionMethod) {
        this.fTracerGroupBuilder = tracerGroupBuilder;
        this.fSourceMethod = sourceMethod;
        this.fInsertionMethod = insertionMethod;
    }

    public TracerGroupBuilder getTracerGroupBuilder() {
        return this.fTracerGroupBuilder;
    }

    public IMethodName getSourceMethod() {
        return this.fSourceMethod;
    }

    public FullyQualifiedMethodName getInsertionMethod() {
        return this.fInsertionMethod;
    }

    @Override
    public ITransformation generateTransformation(ICompilerLog log, IClassName instrumentationClass, Map tracerGroups) {
        TracerGroup tracerGroup = this.getTracerGroupBuilder() == null ? null : this.getTracerGroupBuilder().lookupTracerGroup(tracerGroups);
        return new InsertOnSocketIOTransformation(log, tracerGroup, this.getSourceMethod(), this.getInsertionMethod());
    }

    public String toString() {
        return this.fTracerGroupBuilder.getName() + "@" + this.fSourceMethod.getNameAndSignatureString() + "@" + this.fInsertionMethod.getFullyQualifiedNameString();
    }

    public boolean equals(Object o) {
        if (o instanceof InsertOnSocketIOTransformationBuilder) {
            InsertOnSocketIOTransformationBuilder that = (InsertOnSocketIOTransformationBuilder)o;
            return this.fSourceMethod.equals(that.getSourceMethod()) && this.fInsertionMethod.equals((Object)that.getInsertionMethod()) && this.fTracerGroupBuilder.equals(that.getTracerGroupBuilder());
        }
        return false;
    }
}

