/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes.annotations;

import com.wily.diagnos.personality.java.classfile.attributes.annotations.DGElementValue;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public class DGConstantTypeElementValue
extends DGElementValue {
    public static final char kBaseTypeByte = 'B';
    public static final char kBaseTypeChar = 'C';
    public static final char kBaseTypeDouble = 'D';
    public static final char kBaseTypeFloat = 'F';
    public static final char kBaseTypeInt = 'I';
    public static final char kBaseTypeLong = 'J';
    public static final char kBaseTypeShort = 'S';
    public static final char kBaseTypeBoolean = 'Z';
    public static final char kTypeString = 's';
    private Object fConstantValue;
    private char fConstantValueType;

    public DGConstantTypeElementValue(int tag, DataInputStream input, DGConstantPool constantPool) throws IOException {
        super((short)1, constantPool);
        this.fConstantValueType = (char)tag;
        this.loadData(input);
    }

    private void loadData(DataInputStream input) throws IOException {
        short index = input.readShort();
        this.readConstantValue(index);
    }

    private void readConstantValue(int constPoolIndex) {
        if (this.fConstantValueType == 'C') {
            this.fConstantValue = Character.valueOf((char)this.fConstantPool.getInteger(constPoolIndex));
        }
        if (this.fConstantValueType == 'D') {
            this.fConstantValue = this.fConstantPool.getDouble(constPoolIndex);
        }
        if (this.fConstantValueType == 'F') {
            this.fConstantValue = Float.valueOf(this.fConstantPool.getFloat(constPoolIndex));
        }
        if (this.fConstantValueType == 'I') {
            this.fConstantValue = this.fConstantPool.getInteger(constPoolIndex);
        }
        if (this.fConstantValueType == 'J') {
            this.fConstantValue = this.fConstantPool.getLong(constPoolIndex);
        }
        if (this.fConstantValueType == 's') {
            this.fConstantValue = this.fConstantPool.getUtf(constPoolIndex);
        }
        if (this.fConstantValueType == 'B') {
            // empty if block
        }
        if (this.fConstantValueType == 'S') {
            // empty if block
        }
        if (this.fConstantValueType == 'Z') {
            // empty if block
        }
    }

    public Object getConstantValue() {
        return this.fConstantValue;
    }

    public char getConstantValueType() {
        return this.fConstantValueType;
    }
}

