/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes.stackmapframe;

import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGDoubleVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGFloatVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGIntegerVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGLongVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGNullVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGObjectVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGTopVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGUninitializedThisVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGUninitializedVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGVerificationTypeInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DGVerificationTypeInfoArray {
    private DGVerificationTypeInfo[] fTypes;

    public DGVerificationTypeInfoArray(int count, DataInputStream data) throws IOException {
        this.fTypes = new DGVerificationTypeInfo[count];
        block11: for (int i = 0; i < count; ++i) {
            int infoType = data.readUnsignedByte();
            switch (infoType) {
                case 0: {
                    this.fTypes[i] = new DGTopVariableInfo(data);
                    continue block11;
                }
                case 1: {
                    this.fTypes[i] = new DGIntegerVariableInfo(data);
                    continue block11;
                }
                case 2: {
                    this.fTypes[i] = new DGFloatVariableInfo(data);
                    continue block11;
                }
                case 3: {
                    this.fTypes[i] = new DGDoubleVariableInfo(data);
                    continue block11;
                }
                case 4: {
                    this.fTypes[i] = new DGLongVariableInfo(data);
                    continue block11;
                }
                case 5: {
                    this.fTypes[i] = new DGNullVariableInfo(data);
                    continue block11;
                }
                case 6: {
                    this.fTypes[i] = new DGUninitializedThisVariableInfo(data);
                    continue block11;
                }
                case 7: {
                    this.fTypes[i] = new DGObjectVariableInfo(data);
                    continue block11;
                }
                case 8: {
                    this.fTypes[i] = new DGUninitializedVariableInfo(data);
                    continue block11;
                }
            }
        }
    }

    public DGVerificationTypeInfoArray(int count) {
        this.fTypes = new DGVerificationTypeInfo[count];
        for (int i = 0; i < count; ++i) {
            this.fTypes[i] = new DGTopVariableInfo();
        }
    }

    public DGVerificationTypeInfoArray(DGVerificationTypeInfoArray types1, DGVerificationTypeInfoArray types2) {
        this.fTypes = new DGVerificationTypeInfo[types1.getNumElements() + types2.getNumElements()];
        System.arraycopy(types1.fTypes, 0, this.fTypes, 0, types1.getNumElements());
        System.arraycopy(types2.fTypes, 0, this.fTypes, types1.getNumElements(), types2.getNumElements());
    }

    public DGVerificationTypeInfoArray(DGVerificationTypeInfoArray types, int numToChop) {
        int newSize = types.getNumElements() - numToChop;
        if (newSize < 0) {
            newSize = 0;
        }
        this.fTypes = new DGVerificationTypeInfo[newSize];
        System.arraycopy(types.fTypes, 0, this.fTypes, 0, newSize);
    }

    public DGVerificationTypeInfoArray(DGVerificationTypeInfo info) {
        this.fTypes = new DGVerificationTypeInfo[1];
        this.fTypes[0] = info;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        for (int i = 0; i < this.fTypes.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.fTypes[i]);
        }
        result.append("]");
        return result.toString();
    }

    public void write(DataOutputStream out) throws IOException {
        for (int i = 0; i < this.fTypes.length; ++i) {
            this.fTypes[i].write(out);
        }
    }

    public int size() {
        int len = 0;
        for (int i = 0; i < this.fTypes.length; ++i) {
            len += this.fTypes[i].size();
        }
        return len;
    }

    public DGVerificationTypeInfo getTypeInfo(int slot) {
        return this.fTypes[this.getIndexForSlot(slot)];
    }

    public void setTypeInfo(int index, byte infoType, int arg) {
        switch (infoType) {
            case 0: {
                this.fTypes[index] = new DGTopVariableInfo();
                break;
            }
            case 1: {
                this.fTypes[index] = new DGIntegerVariableInfo();
                break;
            }
            case 2: {
                this.fTypes[index] = new DGFloatVariableInfo();
                break;
            }
            case 3: {
                this.fTypes[index] = new DGDoubleVariableInfo();
                break;
            }
            case 4: {
                this.fTypes[index] = new DGLongVariableInfo();
                break;
            }
            case 5: {
                this.fTypes[index] = new DGNullVariableInfo();
                break;
            }
            case 6: {
                this.fTypes[index] = new DGUninitializedThisVariableInfo();
                break;
            }
            case 7: {
                this.fTypes[index] = new DGObjectVariableInfo(arg);
                break;
            }
            case 8: {
                this.fTypes[index] = new DGUninitializedVariableInfo(arg);
                break;
            }
        }
    }

    public int getNumElements() {
        return this.fTypes.length;
    }

    public void copyTypeInfo(int dstIdx, DGVerificationTypeInfoArray types, int srcIdx) {
        this.fTypes[dstIdx] = types.fTypes[srcIdx];
    }

    public int getNumSlotsUsed() {
        int slots = 0;
        for (int i = 0; i < this.fTypes.length; ++i) {
            slots += this.fTypes[i].getNumSlotsUsed();
        }
        return slots;
    }

    public int getIndexForSlot(int slot) {
        int current = 0;
        for (int index = 0; index < this.fTypes.length; ++index) {
            if (current >= slot) {
                return index;
            }
            current += this.fTypes[index].getNumSlotsUsed();
        }
        return index += slot - current;
    }

    public boolean updateUninitializedVariableOffset(int pc, int delta) {
        boolean dirty = false;
        for (int index = 0; index < this.fTypes.length; ++index) {
            DGUninitializedVariableInfo uvi;
            int offset;
            if (!(this.fTypes[index] instanceof DGUninitializedVariableInfo) || (offset = (uvi = (DGUninitializedVariableInfo)this.fTypes[index]).getOffset()) < pc) continue;
            uvi.setOffset(offset + delta);
            dirty = true;
        }
        return dirty;
    }
}

