/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.loading;

import com.wily.diagnos.personality.ICompilerPersonality;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.autoprobe.loading.ADirectiveLoader;
import com.wily.introscope.autoprobe.loading.IDirectiveLoader;
import com.wily.util.resource.IResourceReader;
import com.wily.util.text.IStringLocalizer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class ASignedDirectiveLoader
extends ADirectiveLoader
implements IDirectiveLoader {
    private Set publicKeys = this.getPublicKeys();
    private static final int kBufSize = 1024;
    public static byte[] tempBuf = new byte[1024];

    protected ASignedDirectiveLoader(IAgent agent, IStringLocalizer localizer, IResourceReader resourceReader, String path, String[] directivesFiles, ICompilerPersonality personality) {
        super(agent, localizer, resourceReader, path, directivesFiles, personality);
    }

    public List extractAndVerify(JarFile jarFile) {
        boolean isJarValid;
        JarEntry entry;
        ArrayList verifiedEntries = new ArrayList();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        for (isJarValid = true; jarEntries.hasMoreElements() && isJarValid; isJarValid &= this.verifySingleEntry(entry, jarFile, this.publicKeys, verifiedEntries)) {
            entry = jarEntries.nextElement();
        }
        if (!isJarValid) {
            verifiedEntries = null;
        }
        return verifiedEntries;
    }

    private boolean verifySingleEntry(JarEntry entry, JarFile file, Set keys, List verifiedList) {
        Certificate[] certs;
        boolean hasValidated = false;
        if (entry.isDirectory() || entry.getName().toLowerCase().startsWith("meta-inf")) {
            hasValidated = true;
        } else if (this.verifyStream(entry, file) && (certs = entry.getCertificates()) != null) {
            for (int i = 0; i < certs.length && !hasValidated; ++i) {
                Iterator it = keys.iterator();
                while (it.hasNext() && !hasValidated) {
                    try {
                        PublicKey key = (PublicKey)it.next();
                        certs[i].verify(key);
                        hasValidated = true;
                        verifiedList.add(entry);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (!hasValidated) {
            this.getFeedback().warn(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Directive_Loader_Validation_Failed_No_Key_Match", entry.getName()));
        }
        return hasValidated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyStream(JarEntry entry, JarFile file) {
        boolean result = false;
        InputStream stream = null;
        try {
            stream = file.getInputStream(entry);
            while (stream.read(tempBuf) > 0) {
            }
            result = true;
        }
        catch (IOException e) {
            this.getFeedback().error(this.getLocalizer().IStringLocalizer_getLocalizedString("Directive_Loader_Err_Verifying_Stream"));
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    protected Set getPublicKeys() {
        HashSet<PublicKey> result = new HashSet<PublicKey>();
        try {
            File thisJarFile = new File(this.getPath());
            JarFile jFile = new JarFile(thisJarFile);
            Enumeration<JarEntry> entries = jFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                this.verifyStream(entry, jFile);
                Certificate[] certs = entry.getCertificates();
                if (certs == null) continue;
                for (int i = 0; i < certs.length; ++i) {
                    result.add(certs[i].getPublicKey());
                }
            }
            jFile.close();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getFeedback().error("An exception occurred getting public keys.");
                this.getFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }
}

