/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection;

import com.wily.introscope.agent.intelligent.detection.RecordingCounter;
import com.wily.introscope.agent.intelligent.detection.RunSelectionId;
import com.wily.introscope.agent.intelligent.detection.StackTraceConsumer;
import com.wily.introscope.agent.intelligent.detection.StackTraceProvider;

public abstract class RecordingData
implements RunSelectionId,
RecordingCounter,
StackTraceProvider,
StackTraceConsumer {
    public static final int RUN_SELECTION_ID_INITIAL_VALUE = 0;
    private volatile int count = 0;
    private volatile int runSelectionId = 0;
    private volatile SelectionStatus threadSelectionStatus = SelectionStatus.PENDING;

    @Override
    public int getRunSelectionId() {
        return this.runSelectionId;
    }

    @Override
    public void setRunSelectionId(int id) {
        this.runSelectionId = id;
    }

    @Override
    public int getRecordingsCount() {
        return this.count;
    }

    @Override
    public int incrementAndGetRecordingsCount() {
        return ++this.count;
    }

    @Override
    public void resetRecordingsCount() {
        this.count = 0;
    }

    public void reset() {
        this.resetRecordingsCount();
        this.resetThreadSelectionStatus();
    }

    @Override
    public abstract boolean acceptTrace(StackTraceElement[] var1);

    @Override
    public abstract StackTraceElement[] getTrace();

    public boolean isThreadPicked() {
        return SelectionStatus.PICKED == this.threadSelectionStatus;
    }

    public boolean isThreadRejected() {
        return SelectionStatus.REJECTED == this.threadSelectionStatus;
    }

    public boolean isThreadStatusPending() {
        return SelectionStatus.PENDING == this.threadSelectionStatus;
    }

    public void setThreadSelectionStatus(boolean isThreadSelected) {
        this.threadSelectionStatus = isThreadSelected ? SelectionStatus.PICKED : SelectionStatus.REJECTED;
    }

    public void setThreadSelectionStatus(SelectionStatus status) {
        this.threadSelectionStatus = status;
    }

    public SelectionStatus getThreadSelectionStatus() {
        return this.threadSelectionStatus;
    }

    public void resetThreadSelectionStatus() {
        this.threadSelectionStatus = SelectionStatus.PENDING;
    }

    public static enum SelectionStatus {
        PICKED,
        REJECTED,
        PENDING;

    }
}

