/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection.rules;

import com.wily.agent.main.IIntelligentInstrumentationTracerHelper;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.detection.rules.AbstractFailFastRule;
import com.wily.introscope.agent.intelligent.detection.rules.CommonUtils;
import com.wily.introscope.agent.intelligent.detection.rules.InstrumentationCheck;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.autoprobe.AutoProbeTransformer;

public class SkipMethodIfAlreadyInstrumentedRule
extends AbstractFailFastRule
implements InstrumentationCheck {
    private final IIntelligentInstrumentationTracerHelper helper;
    private static final Class[] EMPTY_ARRAY = new Class[0];
    private volatile Class[] allClassesInVm = EMPTY_ARRAY;

    private SkipMethodIfAlreadyInstrumentedRule() {
        IIntelligentInstrumentationTracerHelper h = null;
        try {
            h = AgentShim.getAgent().IAgent_getTracerAdministrator().getIntelligentInstrumentationService();
        }
        catch (Exception e) {
            Logger.logException((String)("Error while initializing " + ((Object)((Object)this)).getClass().getName()), (Exception)e);
        }
        this.helper = h;
    }

    private SkipMethodIfAlreadyInstrumentedRule(AutoProbeTransformer autoProbeTransformer) {
        this(autoProbeTransformer.getAgent());
    }

    private SkipMethodIfAlreadyInstrumentedRule(IAgent agent) {
        this.helper = agent != null ? agent.IAgent_getTracerAdministrator().getIntelligentInstrumentationService() : null;
    }

    public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        if (this.helper != null) {
            this.refreshRepoOnApply();
            IndexAwareTraceElement traceElement = trace[currentElementIndex];
            String className = traceElement.getClassName();
            String methodName = traceElement.getMethodName();
            return !this.helper.areMatchingMethodsTraced(className, methodName, this.allClassesInVm);
        }
        return true;
    }

    public boolean isInstrumented(String className, String methodName) {
        return this.helper != null && this.helper.areMatchingMethodsTraced(className, methodName, this.getClassRepo());
    }

    private Class[] getClassRepo() {
        if (this.helper != null) {
            return this.helper.getAllClassesInVm();
        }
        return EMPTY_ARRAY;
    }

    private void refreshRepoOnApply() {
        if (this.allClassesInVm == EMPTY_ARRAY) {
            this.allClassesInVm = this.getClassRepo();
        }
    }

    public void teardownAfterTraceEval() {
        this.allClassesInVm = EMPTY_ARRAY;
    }

    public String toString() {
        return CommonUtils.formatStringRep((String)((Object)((Object)this)).getClass().getSimpleName());
    }

    public static SkipMethodIfAlreadyInstrumentedRule getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        private static final SkipMethodIfAlreadyInstrumentedRule INSTANCE = new SkipMethodIfAlreadyInstrumentedRule();

        private SingletonHolder() {
        }
    }
}

