/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.filters;

import com.wily.agent.main.IIntelligentInstrumentationTracerHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.apis.StackTraceFilter;
import com.wily.introscope.agent.intelligent.entrypoint.filters.AbstractStackTraceFilter;
import com.wily.introscope.agent.trace.intelligent.frontend.FrontendCandidate;
import java.util.Arrays;

public class BlacklistedElementsFilter
extends AbstractStackTraceFilter
implements StackTraceFilter {
    private IIntelligentInstrumentationTracerHelper insHelper;

    public BlacklistedElementsFilter(IAgent agent) {
        if (agent != null) {
            this.insHelper = agent.IAgent_getTracerAdministrator().getIntelligentInstrumentationService();
        }
    }

    @Override
    public IndexAwareTraceElement[] filter(IndexAwareTraceElement[] traceElements) {
        IndexAwareTraceElement[] includedElements = null;
        IndexAwareTraceElement element = null;
        int size = traceElements.length;
        int fromIndex = 0;
        int toIndex = size;
        for (int i = 0; i < size; ++i) {
            element = traceElements[i];
            if (!this.isBlacklisted(element)) continue;
            if (Logger.isTraceEnabled()) {
                Logger.logTraceMessage((String)("Found blacklisted trace element: " + element));
            }
            toIndex = i;
            break;
        }
        includedElements = Arrays.copyOfRange(traceElements, fromIndex, toIndex);
        return includedElements;
    }

    private boolean isBlacklisted(IndexAwareTraceElement element) {
        if (this.insHelper != null) {
            return this.insHelper.isMethodInState(element.getClassName(), element.getMethodName(), FrontendCandidate.FrontEndCandidateState.REJECTED.toString());
        }
        return false;
    }
}

