/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.stacktrace;

import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.feature.IThreadStackSnapshotHelper;
import com.wily.introscope.agent.intelligent.detection.ConditionalTraceRecorder;
import com.wily.introscope.agent.intelligent.detection.RecordingData;
import com.wily.introscope.agent.intelligent.detection.StackTraceProvider;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.StackTraceRecordingController;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.StackTraceRepository;

public class EntryPointStackTraceRecorder
implements ConditionalTraceRecorder {
    @Override
    public boolean record(RecordingData threadLocalRecData, StackTraceProvider provider) {
        if (StackTraceRecordingController.shouldRecordStackTrace(threadLocalRecData)) {
            boolean status = this.recordTraceInternal(provider);
            if (status) {
                StackTraceRecordingController.notifyRecordingListeners(threadLocalRecData);
            }
            return true;
        }
        return false;
    }

    private boolean recordTraceInternal(StackTraceProvider provider) {
        StackTraceElement[] traceElements = provider.getTrace();
        if (traceElements == null) {
            Logger.logDebugMessage((String)"EntryPoint StackTraceRecorder: Recording trace in repository");
            traceElements = Thread.currentThread().getStackTrace();
        } else {
            Logger.logDebugMessage((String)"EntryPoint StackTraceRecorder: Skipping own recording. Reusing provided stack trace");
        }
        boolean status = StackTraceRepository.add(traceElements);
        IThreadStackSnapshotHelper helper = ErrorFeature.sThreadStackHelper;
        if (helper != null) {
            Thread t = Thread.currentThread();
            helper.sendThreadStackSnapshot(null, "Entrypoint Detection", null, null, traceElements, null, null, t);
        }
        return status;
    }
}

