/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.exitpoint.stacktrace;

import java.util.concurrent.atomic.AtomicInteger;

public class TraceRecordingTicketMaster {
    private volatile int totalTickets = 2;
    private final AtomicInteger ticketsAvailable = new AtomicInteger(this.totalTickets);

    private TraceRecordingTicketMaster() {
    }

    public boolean requestTicket() {
        return this.ticketsAvailable.getAndDecrement() > 0;
    }

    public void reset() {
        this.ticketsAvailable.set(this.totalTickets);
    }

    public int getAvailableTickets() {
        int n = this.ticketsAvailable.get();
        return n > 0 ? n : 0;
    }

    public int getTotalTickets() {
        return this.totalTickets;
    }

    public void setTotalTickets(int totalTickets) {
        this.totalTickets = totalTickets;
    }

    public static TraceRecordingTicketMaster getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        private static final TraceRecordingTicketMaster INSTANCE = new TraceRecordingTicketMaster();

        private SingletonHolder() {
        }
    }
}

