/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class DefaultedMap<K, V>
implements Map<K, V> {
    private final Map<K, V> fDelegate;
    private final V fDefaultValue;

    public static <K, V> Map<K, V> decorate(Map<K, V> map, V defaultValue) {
        return new DefaultedMap<K, V>(map, defaultValue);
    }

    private DefaultedMap(Map<K, V> delegate, V defaultValue) {
        if (delegate == null) {
            throw new NullPointerException("A null map is not allowed.");
        }
        this.fDelegate = delegate;
        this.fDefaultValue = defaultValue;
    }

    @Override
    public void clear() {
        this.fDelegate.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.fDelegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.fDelegate.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.fDelegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.fDelegate.equals(o);
    }

    @Override
    public V get(Object key) {
        if (!this.containsKey(key)) {
            return this.fDefaultValue;
        }
        return this.fDelegate.get(key);
    }

    @Override
    public int hashCode() {
        return this.fDelegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.fDelegate.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.fDelegate.keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.fDelegate.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.fDelegate.putAll(t);
    }

    @Override
    public V remove(Object key) {
        return this.fDelegate.remove(key);
    }

    @Override
    public int size() {
        return this.fDelegate.size();
    }

    @Override
    public Collection<V> values() {
        return this.fDelegate.values();
    }
}

