/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.commands;

import com.ca.agent.extensions.dbmon.DBMonAPMMetric;
import com.ca.agent.extensions.dbmon.DBMonCommand;
import com.ca.agent.extensions.dbmon.DBMonException;
import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.sql.Connection;

public class DBMonCheckDBAvailabilityCommand
implements DBMonCommand {
    private IModuleFeedbackChannel logger;
    private Connection conn;

    @Override
    public boolean execute(DBMonMetricsContext dbContext) throws DBMonException {
        this.logger = dbContext.getAgent().IAgent_getModuleFeedback();
        this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Connecting to database...");
        try {
            this.conn = dbContext.initializeConnection();
            dbContext.getApmMetrics().add(new DBMonAPMMetric("Availability", "IntFluctuatingCounter", "1"));
        }
        catch (Exception exe) {
            dbContext.getApmMetrics().add(new DBMonAPMMetric("Availability", "IntFluctuatingCounter", "0"));
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, dbContext.printDbConnectionDetails(), (Throwable)exe);
        }
        finally {
            try {
                if (this.conn != null) {
                    this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Closed Database Connection Successfully...");
                    this.conn.close();
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
        }
        return true;
    }
}

