/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.commands;

import com.ca.agent.extensions.dbmon.DBMonAPMAttribute;
import com.ca.agent.extensions.dbmon.DBMonCommand;
import com.ca.agent.extensions.dbmon.DBMonException;
import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.ca.agent.extensions.dbmon.atc.ApmData;
import com.ca.agent.extensions.dbmon.atc.DBMonATCManager;
import com.ca.agent.extensions.dbmon.atc.Edge;
import com.ca.agent.extensions.dbmon.atc.Graph;
import com.ca.agent.extensions.dbmon.atc.Vertex;
import com.ca.agent.extensions.dbmon.schema.DBMonInfoSchema;
import com.google.gson.Gson;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DBMonCreateVertexCommand
implements DBMonCommand {
    private static final long THIRTY_MINS = 1800000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(DBMonMetricsContext dbContext) throws DBMonException {
        if (dbContext.getLastATCSentTime() != 0L && dbContext.getLastATCSentTime() > System.currentTimeMillis() - 1800000L) {
            return false;
        }
        IModuleFeedbackChannel logger = dbContext.getAgent().IAgent_getModuleFeedback();
        DBMonATCManager atcManager = dbContext.getDbMonATCManager();
        IAgent agent = dbContext.getAgent();
        int connectionWaitCounter = 0;
        IsengardServerConnectionManager connectionManager = agent.IAgent_getIsengardServerConnection();
        while (!(atcManager.isConnectionUp() && connectionManager != null && connectionManager.shouldSendData() || connectionWaitCounter++ >= 10)) {
            try {
                logger.info(DBMonMetricsContext.DBMON_MODULE, "Waiting for EM connection to be up, sleeping for 30 seconds");
                TimeUnit.SECONDS.sleep(30L);
            }
            catch (InterruptedException e) {
                logger.error(DBMonMetricsContext.DBMON_MODULE, "Thread waiting for EM connection to be up interrupted");
            }
        }
        if (!atcManager.isConnectionUp()) {
            return false;
        }
        dbContext.setLastATCSentTime(System.currentTimeMillis());
        Graph graph = new Graph();
        Gson gson = new Gson();
        String[] agentTripplet = dbContext.getAgent().IAgent_getHostProcessAgentTriplet();
        String sAgentTrippletCombined = agentTripplet[0] + "|" + agentTripplet[1] + "|" + agentTripplet[2];
        ArrayList<String> verticesToSend = new ArrayList<String>();
        DBMonInfoSchema dbInfo = dbContext.getDbInfoSchema();
        Connection conn = null;
        try {
            conn = dbContext.initializeConnection();
        }
        catch (Exception e) {
            logger.error(DBMonMetricsContext.DBMON_MODULE, "Unable to connect to database " + dbInfo.getDatabaseType() + ":" + dbInfo.getHostName() + ":" + dbInfo.getInstanceName() + ". ATC node will not be updated.");
            logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)e);
                }
            }
        }
        Vertex vertex = new Vertex();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String name = dbContext.getDbInfoSchema().getDatabaseType() + " @ " + dbInfo.getInstanceName();
        String hostname = dbInfo.getHostName();
        properties.put("hostname", hostname);
        properties.put("ipAddress", this.resolveHostnameToIp(hostname, logger));
        properties.put("agent", sAgentTrippletCombined);
        properties.put("name", name);
        properties.put("type", dbContext.getDbInfoSchema().getDatabaseType());
        properties.put("layer", "INFRASTRUCTURE");
        if (dbContext.isDbTracesEnabled()) {
            properties.put("z_apm_events_enabled", Boolean.TRUE.toString());
            properties.put("z_apm_events_meta", "{\"label\":\"Database\",\"type\":\"DBT\", \"idAttribute\": \"Database Connection\"}");
        }
        properties.put("Database Connection", this.getConnectionString(dbInfo));
        properties.put("Database Port", dbInfo.getPort());
        properties.put("Database Type", dbInfo.getDatabaseType());
        properties.put("Database Name", dbInfo.getInstanceName());
        properties.put("Database Host Name", hostname);
        for (DBMonAPMAttribute attribute : dbContext.getApmAttributes()) {
            if (attribute.getAttributeName().replace(" ", "").equalsIgnoreCase("hostname")) {
                if (!hostname.equalsIgnoreCase("localhost") && !hostname.equals("127.0.0.1")) continue;
                properties.put("hostname", attribute.getAttributeValue());
                properties.put("ipAddress", this.resolveHostnameToIp(attribute.getAttributeValue(), logger));
                continue;
            }
            if (attribute.getAttributeName().startsWith("z_apm")) {
                properties.put(attribute.getAttributeName(), attribute.getAttributeValue());
                continue;
            }
            properties.put("Database " + attribute.getAttributeName(), attribute.getAttributeValue());
        }
        vertex.setAttributes(properties);
        vertex.setId(this.getConnectionString(dbInfo));
        verticesToSend.add(name);
        graph.putVertexInfo(vertex);
        if (dbContext.getDbDetailsSchema().isCluster()) {
            String masterId = this.getConnectionString(dbInfo);
            String slaveType = dbContext.getDbDetailsSchema().getSlaveDatabaseName();
            if (slaveType == null) {
                slaveType = dbInfo.getDatabaseType().replace("_DB", "_INSTANCE");
            }
            for (Map.Entry<String, List<DBMonAPMAttribute>> slaveVertex : dbContext.getAPMClusterAttributes().entrySet()) {
                vertex = new Vertex();
                properties = new HashMap();
                String instanceName = "";
                String hostName = "";
                String instanceId = slaveVertex.getKey();
                List<DBMonAPMAttribute> attributes = slaveVertex.getValue();
                for (DBMonAPMAttribute attribute : attributes) {
                    if (attribute.getAttributeName().equals("Host Name")) {
                        hostName = attribute.getAttributeValue();
                        continue;
                    }
                    if (attribute.getAttributeName().equals("Instance Name")) {
                        instanceName = attribute.getAttributeValue();
                        continue;
                    }
                    properties.put("Database " + attribute.getAttributeName(), attribute.getAttributeValue());
                }
                String slaveId = slaveType + ":" + hostName + ":" + instanceName;
                String slaveName = slaveType + " @ " + instanceName;
                properties.put("hostname", hostName);
                properties.put("ipAddress", this.resolveHostnameToIp(hostname, logger));
                properties.put("agent", sAgentTrippletCombined);
                properties.put("type", slaveType);
                properties.put("layer", "INFRASTRUCTURE");
                properties.put("name", slaveName);
                properties.put("mastername", dbInfo.getInstanceName());
                properties.put("instanceid", instanceId);
                properties.put("Database Type", slaveType);
                properties.put("Database Name", instanceName);
                properties.put("Database Host Name", hostName);
                vertex.setAttributes(properties);
                vertex.setId(slaveId);
                verticesToSend.add(slaveName);
                graph.putVertexInfo(vertex);
                Edge ed = new Edge();
                ed.setSource(masterId);
                ed.setTarget(slaveId);
                ed.setTtl(0x6DDD00L);
                graph.putEdgeInfo(ed);
            }
        }
        ApmData data = new ApmData(graph);
        String jsonData = gson.toJson(data);
        try {
            atcManager.postATCData("/apm/appmap/ats/graph/store", jsonData);
        }
        catch (Exception e) {
            logger.error(DBMonMetricsContext.DBMON_MODULE, "Failed to post ATC data: " + e.getMessage());
            logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)e);
        }
        return true;
    }

    public String getConnectionString(DBMonInfoSchema dbInfo) {
        return dbInfo.getDatabaseType() + ":" + dbInfo.getHostName() + ":" + dbInfo.getPort() + ":" + dbInfo.getInstanceName();
    }

    public String resolveHostnameToIp(String hostName, IModuleFeedbackChannel logger) {
        try {
            InetAddress intAdrs = InetAddress.getByName(hostName);
            return intAdrs.getHostAddress();
        }
        catch (UnknownHostException ex) {
            logger.error("Could not find host : " + hostName, (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error("Exception resolving host :" + hostName, (Throwable)ex);
        }
        return "";
    }
}

