/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.commands;

import com.ca.agent.extensions.dbmon.DBMonAPMAttribute;
import com.ca.agent.extensions.dbmon.DBMonCommand;
import com.ca.agent.extensions.dbmon.DBMonException;
import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.ca.agent.extensions.dbmon.entity.DBMonResultSet;
import com.ca.agent.extensions.dbmon.helper.DBMonJsonPathHelper;
import com.ca.agent.extensions.dbmon.schema.DBMonAttribute;
import com.ca.agent.extensions.dbmon.schema.DBMonSQLAttributeMapping;
import com.google.gson.Gson;
import com.jayway.jsonpath.Configuration;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DBMonPopulateAPMAttributesCommand
implements DBMonCommand {
    private IModuleFeedbackChannel logger;
    private DBMonMetricsContext dbContext;
    private DBMonJsonPathHelper jsonPathHelper = new DBMonJsonPathHelper();

    @Override
    public boolean execute(DBMonMetricsContext dbContext) throws DBMonException {
        this.dbContext = dbContext;
        this.logger = dbContext.getAgent().IAgent_getModuleFeedback();
        Gson gson = new Gson();
        for (Map.Entry<String, DBMonResultSet> entrySet : dbContext.getDbAttributeResultSet().entrySet()) {
            try {
                DBMonResultSet dbMonResultSet = entrySet.getValue();
                String strResultSet = gson.toJson(dbMonResultSet);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Query key:" + entrySet.getKey());
                    this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "result set json object:" + strResultSet);
                }
                Object document = Configuration.defaultConfiguration().jsonProvider().parse(strResultSet);
                for (DBMonSQLAttributeMapping sqlAttributes : dbContext.getDbDetailsSchema().getSqlAttributeMappings()) {
                    if (!sqlAttributes.getQuery().equals(entrySet.getKey())) continue;
                    this.generateAPMAttribute(document, sqlAttributes);
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
        }
        return true;
    }

    private List<String> getInstanceNameList(Object document, List<DBMonAttribute> dbMonAttributeList) {
        ArrayList<String> instanceNameList = new ArrayList<String>();
        for (DBMonAttribute dbMonAttribute : dbMonAttributeList) {
            if (!dbMonAttribute.getAttributeName().equals("CLUSTER_ID")) continue;
            List<String> metricVals = this.jsonPathHelper.evaluate(document, dbMonAttribute.getAttributeValue());
            if (metricVals == null || metricVals.size() == 0) {
                return instanceNameList;
            }
            if (metricVals.size() <= 0) continue;
            for (int i = 0; i < metricVals.size(); ++i) {
                instanceNameList.add(metricVals.get(i));
            }
        }
        return instanceNameList;
    }

    private void generateAPMAttribute(Object document, DBMonSQLAttributeMapping sqlMetrics) {
        if (this.dbContext.getDbDetailsSchema().isCluster()) {
            List<String> instanceNameList = this.getInstanceNameList(document, sqlMetrics.getAttributes());
            if (instanceNameList.size() == 0) {
                for (DBMonAttribute dbMonAttribute : sqlMetrics.getAttributes()) {
                    this.appendValuesToSingleMetric(document, dbMonAttribute);
                }
            } else {
                for (DBMonAttribute dbMonAttribute : sqlMetrics.getAttributes()) {
                    this.generateMultipleAPMAttributes(document, dbMonAttribute, instanceNameList);
                }
            }
        } else {
            for (DBMonAttribute dbMonAttribute : sqlMetrics.getAttributes()) {
                this.appendValuesToSingleMetric(document, dbMonAttribute);
            }
        }
    }

    private void generateMultipleAPMAttributes(Object document, DBMonAttribute dbMonAttribute, List<String> instanceNameList) {
        List<String> metricVals = this.jsonPathHelper.evaluate(document, dbMonAttribute.getAttributeValue());
        for (int i = 0; i < metricVals.size(); ++i) {
            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Instance Name" + instanceNameList.get(i));
            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Attribute Name" + dbMonAttribute.getAttributeName());
            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Attribute Value:" + metricVals.get(i));
            if (this.dbContext.getAPMClusterAttributes().containsKey(instanceNameList.get(i))) {
                this.dbContext.getAPMClusterAttributes().get(instanceNameList.get(i)).add(new DBMonAPMAttribute(dbMonAttribute.getAttributeName(), metricVals.get(i)));
                continue;
            }
            ArrayList<DBMonAPMAttribute> attributes = new ArrayList<DBMonAPMAttribute>();
            attributes.add(new DBMonAPMAttribute(dbMonAttribute.getAttributeName(), metricVals.get(i)));
            this.dbContext.getAPMClusterAttributes().put(instanceNameList.get(i), attributes);
        }
    }

    private void appendValuesToSingleMetric(Object document, DBMonAttribute dbMonAttribute) {
        List<String> metricVals = this.jsonPathHelper.evaluate(document, dbMonAttribute.getAttributeValue());
        if (metricVals == null || metricVals.size() == 0) {
            return;
        }
        this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Attribute Name" + dbMonAttribute.getAttributeName());
        this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Attribute Value:" + metricVals.toString());
        if (metricVals.size() > 0) {
            this.dbContext.getApmAttributes().add(new DBMonAPMAttribute(dbMonAttribute.getAttributeName(), metricVals.get(0)));
        }
    }
}

