/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.commands;

import com.ca.agent.extensions.dbmon.DBMonAPMMetric;
import com.ca.agent.extensions.dbmon.DBMonCommand;
import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.Map;

public class DBMonRemoveStaleMetricsCommand
implements DBMonCommand {
    private IModuleFeedbackChannel logger;
    private int pollingInterval = 0;
    private DBMonMetricsContext dbContext = null;

    @Override
    public boolean execute(DBMonMetricsContext dbContext) {
        this.dbContext = dbContext;
        this.logger = dbContext.getAgent().IAgent_getModuleFeedback();
        this.pollingInterval = dbContext.getDbInfoSchema().getQueryInterval();
        this.removeStaleMetrics(dbContext.getDbAllMetrics());
        return true;
    }

    private void removeStaleMetrics(Map<String, DBMonAPMMetric> dbMetrics) {
        long currentTime = System.currentTimeMillis();
        if (this.dbContext.getDbAllMetrics() != null) {
            for (Map.Entry<String, DBMonAPMMetric> entity : this.dbContext.getDbAllMetrics().entrySet()) {
                DBMonAPMMetric metric = entity.getValue();
                long lastAccessed = metric.getLastAccessedTime();
                if (currentTime - lastAccessed < (long)(this.pollingInterval * 1000 * 3)) continue;
                this.removeMetric(entity.getKey().toString());
                dbMetrics.remove(entity.getKey().toString());
            }
        }
    }

    private void removeMetric(String fullMetricPath) {
        try {
            DataAccumulatorFactory dataAccumulatorFactory = AgentShim.getAgent().IAgent_getDataAccumulatorFactory();
            dataAccumulatorFactory.removeMetric(fullMetricPath);
            this.logger.info(DBMonMetricsContext.DBMON_MODULE, "Stale Metric Removed: " + fullMetricPath);
        }
        catch (Exception e) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, "Exception occurred while removing stale metrics", (Throwable)e);
        }
    }
}

