/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.commands.traces;

import com.ca.agent.extensions.dbmon.DBMonCommand;
import com.ca.agent.extensions.dbmon.DBMonException;
import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.ca.agent.extensions.dbmon.entity.DBMonResultSet;
import com.ca.agent.extensions.dbmon.entity.query.plan.DBMonEventResource;
import com.ca.agent.extensions.dbmon.entity.query.plan.DBMonQueryPlanSnapshot;
import com.ca.agent.extensions.dbmon.helper.DBMonJsonPathHelper;
import com.ca.agent.extensions.dbmon.helper.parser.QueryPlanXMLParser;
import com.ca.agent.extensions.dbmon.schema.DBMonSQLTraceMapping;
import com.ca.agent.extensions.dbmon.schema.DBMonTrace;
import com.ca.agent.extensions.dbmon.traces.DBMonQueryPlanParserFactory;
import com.ca.agent.extensions.dbmon.traces.DBMonQueryPlanXMLParserFactory;
import com.google.gson.Gson;
import com.jayway.jsonpath.Configuration;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DBMonExplainPlanQueryCommand
implements DBMonCommand {
    private static final String TRACE_TYPE = "ExplainPlan";
    private final SimpleDateFormat FORMATTER = new SimpleDateFormat("yyMMddHHmmssSS");
    private static final String STMT_PFX = "Apm_DBMon_St_";
    private IModuleFeedbackChannel logger;
    private Connection conn;
    private DBMonMetricsContext dbContext;
    private DBMonJsonPathHelper jsonPathHelper = new DBMonJsonPathHelper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(DBMonMetricsContext dbContext) throws DBMonException {
        this.dbContext = dbContext;
        this.logger = dbContext.getAgent().IAgent_getModuleFeedback();
        this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Connecting to database...");
        try {
            this.conn = dbContext.initializeConnection();
        }
        catch (Exception exe) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, dbContext.printDbConnectionDetails(), (Throwable)exe);
            return false;
        }
        try {
            List<DBMonSQLTraceMapping> sqlTraceMappings = dbContext.getDbDetailsSchema().getSqlTraceMappings();
            for (DBMonSQLTraceMapping traceMapping : sqlTraceMappings) {
                if (traceMapping.getTraceType() == null || !traceMapping.getTraceType().equalsIgnoreCase(TRACE_TYPE) || !this.hasTraceDbResultToProcess(traceMapping)) continue;
                List<String> resultsQueries = this.getTraceMetricResult(traceMapping, traceMapping.buildResultPath());
                List<String> resultSort = this.getTraceMetricResult(traceMapping, traceMapping.buildSortPath());
                List<String> resultParams = this.getTraceMetricResult(traceMapping, traceMapping.buildParamPath());
                Boolean planContentParsing = this.isPlanRequireContentParsing(traceMapping);
                int i = 0;
                for (String query : resultsQueries) {
                    long duration = resultSort.size() >= i ? Long.parseLong(resultSort.get(i)) : 0L;
                    String planQueryParam = resultParams.size() >= i ? resultParams.get(i) : null;
                    this.fireAndGenerateQueryPlanSnapshot(new DBMonEventResource(query, duration), traceMapping, planQueryParam);
                    if (planContentParsing.booleanValue()) {
                        this.parseAndGenerateQueryPlanSnapshot(new DBMonEventResource(query, duration), traceMapping, planQueryParam);
                    } else {
                        this.fireAndGenerateQueryPlanSnapshot(new DBMonEventResource(query, duration), traceMapping, planQueryParam);
                    }
                    ++i;
                }
            }
        }
        finally {
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAndGenerateQueryPlanSnapshot(DBMonEventResource dbMonEventResource, DBMonSQLTraceMapping traceMapping, String planQueryParam) {
        DBMonQueryPlanSnapshot queryPlanSnapshot = this.initializeQueryPlanSnapshot(traceMapping);
        try {
            QueryPlanXMLParser planXMLParser = DBMonQueryPlanXMLParserFactory.getPlanXMLParser(this.dbContext.getDbDetailsSchema().getDatabaseName());
            queryPlanSnapshot.setQueryPlan(planXMLParser.parse(planQueryParam));
        }
        catch (Exception e) {
            this.logger.warn(String.format("Unable to parse query plan for query [ %20s ...]", dbMonEventResource.getQuery()));
        }
        finally {
            this.dbContext.getDbQueryPlanResultSet().put(dbMonEventResource, queryPlanSnapshot);
        }
    }

    private DBMonQueryPlanSnapshot initializeQueryPlanSnapshot(DBMonSQLTraceMapping traceMapping) {
        DBMonQueryPlanSnapshot queryPlanSnapshot = new DBMonQueryPlanSnapshot();
        DBMonTrace dbTrace = traceMapping.getTraces().get(0);
        queryPlanSnapshot.setTraceResourcePathPrefix(dbTrace.getTraceResourcePathPrefix());
        queryPlanSnapshot.setTraceType(dbTrace.getTraceType());
        queryPlanSnapshot.setMetaAttributes(traceMapping.getTraceDetails());
        return queryPlanSnapshot;
    }

    private Boolean isPlanRequireContentParsing(DBMonSQLTraceMapping traceMapping) {
        DBMonTrace traceConfig = traceMapping.getTraces().get(0);
        return traceConfig.getPlanParsing().size() > 0;
    }

    private boolean hasTraceDbResultToProcess(DBMonSQLTraceMapping traceMapping) {
        if (traceMapping.getQuery() == null || traceMapping.getQuery().isEmpty()) {
            this.logger.info("No Source Query mentioned for trace of type - ExplainPlan");
            return false;
        }
        return this.dbContext.getDbTraceResultSet().get(traceMapping.getQuery()) != null;
    }

    private List<String> getTraceMetricResult(DBMonSQLTraceMapping traceMapping, String path) {
        if (traceMapping.getMetric() == null) {
            this.logger.warn("No Source Query metric details mentioned for trace of type - ExplainPlan");
            return Collections.emptyList();
        }
        DBMonResultSet dbMonResultSet = this.dbContext.getDbTraceResultSet().get(traceMapping.getQuery());
        Gson gson = new Gson();
        String resultSetStr = gson.toJson(dbMonResultSet);
        Object document = Configuration.defaultConfiguration().jsonProvider().parse(resultSetStr);
        return this.jsonPathHelper.evaluate(document, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAndGenerateQueryPlanSnapshot(DBMonEventResource query, DBMonSQLTraceMapping traceMapping, String planQueryParam) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Query to be processed for query plan is:" + query);
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            for (DBMonTrace dbTrace : traceMapping.getTraces()) {
                try {
                    stmt = this.conn.createStatement();
                    rs = this.executeTraceQueries(query.getQuery(), stmt, rs, dbTrace, planQueryParam);
                    DBMonQueryPlanSnapshot queryPlanSnapshot = new DBMonQueryPlanSnapshot();
                    queryPlanSnapshot.setTraceResourcePathPrefix(dbTrace.getTraceResourcePathPrefix());
                    queryPlanSnapshot.setTraceType(dbTrace.getTraceType());
                    queryPlanSnapshot.setMetaAttributes(traceMapping.getTraceDetails());
                    if (rs == null) continue;
                    this.parseQueryPlanResultToSnapshot(this.dbContext.getDbInfoSchema().getDatabaseType(), rs, queryPlanSnapshot);
                    this.dbContext.getDbQueryPlanResultSet().put(query, queryPlanSnapshot);
                }
                catch (SQLException e) {
                    this.logger.error(DBMonMetricsContext.DBMON_MODULE, String.format("Error occurred while executing trace queries %s ", e.getMessage()));
                }
                finally {
                    try {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                    catch (Exception exe) {
                        this.logger.error(DBMonMetricsContext.DBMON_MODULE, "Error occurred while closing Statement object", (Throwable)exe);
                    }
                }
            }
        }
        catch (Exception exe) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, String.format("Error Processing db trace for [ %s ] - %s ", TRACE_TYPE, exe.getMessage()));
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
        }
    }

    private ResultSet executeTraceQueries(String query, Statement stmt, ResultSet rs, DBMonTrace dbTrace, String planQueryParam) {
        try {
            if (dbTrace.getPreQuery() != null && !dbTrace.getPreQuery().isEmpty()) {
                String stmtId = STMT_PFX + this.FORMATTER.format(new Date());
                stmt.execute(DBMonExplainPlanQueryCommand.buildPreQuerySQLWithParams(dbTrace.getPreQuery(), stmtId, query));
                rs = stmt.executeQuery(DBMonExplainPlanQueryCommand.buildQuerySQLWithParams(dbTrace.getQuery(), stmtId));
            } else {
                rs = StringUtils.isEmpty((String)planQueryParam) ? stmt.executeQuery(DBMonExplainPlanQueryCommand.buildQuerySQLWithParams(dbTrace.getQuery(), query)) : stmt.executeQuery(DBMonExplainPlanQueryCommand.buildQuerySQLWithParams(dbTrace.getQuery(), planQueryParam));
            }
        }
        catch (SQLException sqe) {
            this.logger.info(DBMonMetricsContext.DBMON_MODULE, String.format("Explain plain is unavailable for query [ %s ] - %s ", query, sqe.getMessage()));
        }
        catch (Exception exe) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, String.format("Failed to get Query plan for query [ %s ] - %s ", query, exe.getMessage()));
        }
        return rs;
    }

    private void parseQueryPlanResultToSnapshot(String dbType, ResultSet rs, DBMonQueryPlanSnapshot queryPlanSnapshot) throws SQLException {
        ArrayList<Object> planSteps = new ArrayList<Object>();
        while (rs.next()) {
            try {
                planSteps.add(DBMonQueryPlanParserFactory.getQueryPlanForDB(dbType, rs));
            }
            catch (SQLException sqe) {
                this.logger.warn("Unable to parse query plan " + sqe.getMessage());
            }
        }
        queryPlanSnapshot.setQueryPlan(planSteps);
    }

    public static String buildPreQuerySQLWithParams(String preQuery, String statementId, String query) {
        return String.format(preQuery, statementId, query);
    }

    public static String buildQuerySQLWithParams(String query, String ... statementId) {
        return String.format(query, statementId);
    }
}

