/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.commands.traces;

import com.ca.agent.extensions.dbmon.DBMonCommand;
import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.ca.agent.extensions.dbmon.entity.query.plan.DBMonEventResource;
import com.ca.agent.extensions.dbmon.entity.query.plan.DBMonQueryPlanSnapshot;
import com.ca.agent.extensions.dbmon.entity.query.snapshot.DBMonGenericSnapshot;
import com.ca.agent.extensions.dbmon.schema.DBMonInfoSchema;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DBMonPushTraceSnapshotToEMCommand
implements DBMonCommand {
    public static final String EXPLAIN_PLAN_TYPE = "Explain Plan";
    public static final String TT_QP = "QP";
    public static final String SNAPSHOT_DATA_TYPE = "Snapshot";
    public static final String TT_GSP = "GSP";
    public static final String TT_DB = "DBT";
    public static final int BATCH_SIZE = 5;
    public static final int QP_BATCH_SIZE = 10;
    public static final String URL_PREFIX = "Apps|DBMon|URLs|";
    private IModuleFeedbackChannel logger;
    private DBMonMetricsContext dbContext;
    private IAgent fAgent;

    @Override
    public boolean execute(DBMonMetricsContext dbContext) {
        this.dbContext = dbContext;
        this.fAgent = dbContext.getAgent();
        this.logger = dbContext.getAgent().IAgent_getModuleFeedback();
        if (!dbContext.getAgent().IAgent_getIsengardServerConnection().shouldSendData()) {
            this.logger.warn("EM Down/Unavailable Not sending DB Events");
            return true;
        }
        if (this.hasQueryPlanTraces()) {
            this.sendQueryPlanSnapshotToEM();
        }
        if (this.hasGenericSnapshots()) {
            this.sendGenericSnapshotToEM();
        }
        return true;
    }

    private boolean hasGenericSnapshots() {
        return this.dbContext.getDbMonSnapshot() != null && this.dbContext.getDbMonSnapshot().size() > 0;
    }

    private boolean hasQueryPlanTraces() {
        return this.dbContext.getDbQueryPlanResultSet() != null && this.dbContext.getDbQueryPlanResultSet().size() > 0;
    }

    private void sendQueryPlanSnapshotToEM() {
        Map<DBMonEventResource, DBMonQueryPlanSnapshot> dbQueryPlanResultSet = this.dbContext.getDbQueryPlanResultSet();
        String connectUrl = this.getConnectionString(this.dbContext.getDbInfoSchema());
        if (dbQueryPlanResultSet != null) {
            ArrayList<DBMonEventResource> keys = new ArrayList<DBMonEventResource>(dbQueryPlanResultSet.keySet());
            Collections.sort(keys, new DBMonEventResource());
            for (DBMonEventResource key : keys) {
                DBMonQueryPlanSnapshot dbMonQueryPlanSnapshot = dbQueryPlanResultSet.get(key);
                if (dbMonQueryPlanSnapshot == null) continue;
                try {
                    this.queueSlowQueryEvent(key, connectUrl, dbMonQueryPlanSnapshot.getTraceType(), SNAPSHOT_DATA_TYPE, dbMonQueryPlanSnapshot.getQueryPlan(), dbMonQueryPlanSnapshot.getMetaAttributes());
                }
                catch (Exception e) {
                    this.logger.warn(String.format("Unable to Generate DBTransaction Trace for query [ %20s ...]", key.getQuery()), (Throwable)e);
                }
            }
        }
    }

    private void sendGenericSnapshotToEM() {
        Map<String, DBMonGenericSnapshot> dbMonSnapshots = this.dbContext.getDbMonSnapshot();
        String connectUrl = this.getConnectionString(this.dbContext.getDbInfoSchema());
        if (dbMonSnapshots != null) {
            for (Map.Entry<String, DBMonGenericSnapshot> entry : dbMonSnapshots.entrySet()) {
                DBMonGenericSnapshot dbMonSnapshot = dbMonSnapshots.get(entry.getKey());
                if (dbMonSnapshot == null) continue;
                this.queueTraceEvent(new DBMonEventResource(dbMonSnapshot.getTraceResourcePath(), dbMonSnapshot.getDuration()), connectUrl, dbMonSnapshot.getTraceType(), SNAPSHOT_DATA_TYPE, dbMonSnapshot.getSnapshot(), dbMonSnapshot.getMetaAttributes());
            }
        }
    }

    private void queueSlowQueryEvent(DBMonEventResource resourcePath, String url, String traceType, String eventDataType, List<Object> events, Map<String, Object> attributes) {
        try {
            if (events == null || events.size() == 0) {
                return;
            }
            TransactionComponentData dbEvent = TransactionComponentData.createMilliSecTransactionComponentData((String)resourcePath.getQuery(), (long)System.currentTimeMillis(), (long)resourcePath.getDuration());
            dbEvent.setParameterValue("Trace Type", TT_DB);
            dbEvent.setParameterValue("URL", URL_PREFIX + url);
            dbEvent.setParameterValue("APMIA.dbMonitor.dbIdentifier", url);
            dbEvent.setParameterValue("DBTraceType", traceType);
            if (attributes != null) {
                for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                    dbEvent.setParameterValue(entry.getKey(), entry.getValue().toString());
                }
            }
            Gson gson = new GsonBuilder().create();
            List<Object> listOfMaps = events;
            int batches = this.computeBatchCount(listOfMaps.size(), 10);
            TransactionComponentData[] snapshotComponents = new TransactionComponentData[batches];
            int i = 0;
            int j = batches - 1;
            while (i < listOfMaps.size()) {
                int nextInc = Math.min(listOfMaps.size() - i, 10);
                List<Object> snapshot = listOfMaps.subList(i, i + nextInc);
                snapshotComponents[j] = TransactionComponentData.createMilliSecTransactionComponentData((String)resourcePath.getQuery(), (long)System.currentTimeMillis(), (long)0L);
                snapshotComponents[j].setParameterValue(eventDataType, gson.toJson(snapshot));
                snapshotComponents[j].setParameterValue("URL", URL_PREFIX + url);
                i += nextInc;
                --j;
            }
            dbEvent.setSubNodes(snapshotComponents);
            this.fAgent.IAgent_queueEvent(dbEvent);
        }
        catch (Exception e) {
            this.logger.warn("Unable to Create DB Trace ", (Throwable)e);
        }
    }

    private void queueTraceEvent(DBMonEventResource resourcePath, String url, String traceType, String eventDataType, List<Map<String, Object>> events, Map<String, Object> attributes) {
        try {
            if (events == null || events.size() == 0) {
                return;
            }
            TransactionComponentData dbEvent = TransactionComponentData.createMilliSecTransactionComponentData((String)resourcePath.getQuery(), (long)System.currentTimeMillis(), (long)resourcePath.getDuration());
            dbEvent.setParameterValue("Trace Type", TT_DB);
            dbEvent.setParameterValue("URL", URL_PREFIX + url);
            dbEvent.setParameterValue("APMIA.dbMonitor.dbIdentifier", url);
            dbEvent.setParameterValue("DBTraceType", traceType);
            if (attributes != null) {
                for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                    dbEvent.setParameterValue(entry.getKey(), entry.getValue().toString());
                }
            }
            Gson gson = new GsonBuilder().serializeNulls().create();
            List<Map<String, Object>> listOfMaps = events;
            int batches = this.computeBatchCount(listOfMaps.size(), 5);
            TransactionComponentData[] snapshotComponents = new TransactionComponentData[batches];
            int i = 0;
            int j = batches - 1;
            while (i < listOfMaps.size()) {
                int nextInc = Math.min(listOfMaps.size() - i, 5);
                List<Map<String, Object>> snapshot = listOfMaps.subList(i, i + nextInc);
                snapshotComponents[j] = TransactionComponentData.createMilliSecTransactionComponentData((String)resourcePath.getQuery(), (long)System.currentTimeMillis(), (long)0L);
                snapshotComponents[j].setParameterValue(eventDataType, gson.toJson(snapshot));
                i += nextInc;
                --j;
            }
            dbEvent.setSubNodes(snapshotComponents);
            this.fAgent.IAgent_queueEvent(dbEvent);
        }
        catch (Exception e) {
            this.logger.warn("Unable to Create DB Trace ", (Throwable)e);
        }
    }

    private int computeBatchCount(int size, int batchSize) {
        int lastBatchSize = size % batchSize == 0 ? 0 : 1;
        return size > batchSize ? size / batchSize + lastBatchSize : 1;
    }

    private void queueTraceEvent(String resourcePath, String traceType, String eventDataType, String eventDataJson, Map<String, Object> attributes) {
        try {
            TransactionComponentData queryEvent = TransactionComponentData.createMilliSecTransactionComponentData((String)resourcePath, (long)System.currentTimeMillis(), (long)0L);
            queryEvent.setParameterValue("Trace Type", "Normal");
            TransactionComponentData[] transactionComponents = new TransactionComponentData[1];
            TransactionComponentData epEvent = TransactionComponentData.createMilliSecTransactionComponentData((String)resourcePath, (long)System.currentTimeMillis(), (long)0L);
            epEvent.setParameterValue("Trace Type", traceType);
            epEvent.setParameterValue(eventDataType, eventDataJson);
            transactionComponents[0] = epEvent;
            queryEvent.setSubNodes(transactionComponents);
            this.fAgent.IAgent_queueEvent(queryEvent);
        }
        catch (Exception e) {
            this.logger.warn("Unable to Create DBTransaction Trace ", (Throwable)e);
        }
    }

    public String getConnectionString(DBMonInfoSchema dbInfo) {
        return dbInfo.getDatabaseType() + ":" + dbInfo.getHostName() + ":" + dbInfo.getPort() + ":" + dbInfo.getInstanceName();
    }
}

