/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.helper.parser;

import com.ca.agent.extensions.dbmon.entity.query.plan.DBMonQueryPlan;
import com.ca.agent.extensions.dbmon.entity.query.plan.SQLServerQueryPlan;
import com.ca.agent.extensions.dbmon.helper.parser.QueryPlanXMLParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SQLServerQueryPlanXMLParser
implements QueryPlanXMLParser {
    public static final String SIMPLE_STATEMENT = "//ShowPlanXML/BatchSequence/Batch/Statements/StmtSimple";
    public static final String PLAN_RELOP_PATH = ".//QueryPlan/RelOp";
    public static final String CURRENT_RELOP_PATH = "./*/RelOp";
    public static final String LEVEL_WARNINGS_PATH = ".//Warnings";
    private final String[] attribs = new String[]{"StatementType", "StatementId", "NodeId", "Parent", "PhysicalOp", "LogicalOp", "EstimateRows", "EstimateIO", "EstimateCPU", "AvgRowSize", "EstimatedTotalSubtreeCost", "Parallel", "EstimateExecutions"};

    @Override
    public List<Object> parse(String xml) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document xmlDocument = builder.parse(new ByteArrayInputStream(xml.getBytes()));
        XPath xPath = XPathFactory.newInstance().newXPath();
        ArrayList<Map<String, Object>> planStepsMap = new ArrayList<Map<String, Object>>();
        ArrayList<Object> sqlServerQueryPlan = new ArrayList<Object>();
        NodeList statementList = this.retrieveStatements(xmlDocument, xPath);
        for (int s = 0; s < statementList.getLength(); ++s) {
            Node node = statementList.item(s);
            NamedNodeMap attributes = node.getAttributes();
            HashMap<String, Object> planStep = this.initPlanStep(planStepsMap);
            int parent = 0;
            for (String attr : this.attribs) {
                Node attrNode = attributes.getNamedItem(attr);
                if (attrNode != null) {
                    planStep.put(attr, attrNode.getNodeValue());
                    continue;
                }
                if (attr.equalsIgnoreCase("NodeId")) {
                    parent = 0;
                    planStep.put(attr, "" + parent);
                    continue;
                }
                planStep.put(attr, "NULL");
            }
            double totalCost = this.getValueFromAttribute(attributes, "StatementSubTreeCost");
            planStepsMap.add(planStep);
            NodeList opList = (NodeList)xPath.compile(PLAN_RELOP_PATH).evaluate(node, XPathConstants.NODESET);
            for (int i = 0; i < opList.getLength(); ++i) {
                this.parseOps(xPath, opList.item(i), this.attribs, totalCost, parent, planStepsMap);
            }
        }
        for (Map map : planStepsMap) {
            DBMonQueryPlan dbMonXMLQueryPlanStep = new SQLServerQueryPlan(map).mapResultToPlan();
            sqlServerQueryPlan.add(dbMonXMLQueryPlanStep);
        }
        return sqlServerQueryPlan;
    }

    private NodeList retrieveStatements(Document xmlDocument, XPath xPath) throws XPathExpressionException {
        return (NodeList)xPath.compile(SIMPLE_STATEMENT).evaluate(xmlDocument, XPathConstants.NODESET);
    }

    private double getValueFromAttribute(NamedNodeMap attributes, String costAttributeName) {
        Node attribNode = attributes.getNamedItem(costAttributeName);
        String stringValue = attribNode != null ? attribNode.getNodeValue() : "NULL";
        return this.getAsDouble(stringValue);
    }

    private double getAsDouble(String stringValue) {
        try {
            return Double.parseDouble(stringValue);
        }
        catch (RuntimeException e) {
            return 0.0;
        }
    }

    private void parseOps(XPath xPath, Node n, String[] attribs, Double totalCost, int parent, List<Map<String, Object>> planSteps) throws XPathExpressionException {
        Node warnings;
        NodeList nodes = (NodeList)xPath.compile(CURRENT_RELOP_PATH).evaluate(n, XPathConstants.NODESET);
        int nodeId = 0;
        HashMap<String, Object> planStep = this.initPlanStep(planSteps);
        if (n.getNodeName().equals("RelOp")) {
            NamedNodeMap attributes = n.getAttributes();
            for (String attr : attribs) {
                Node attrNode = attributes.getNamedItem(attr);
                if (attrNode != null) {
                    String attrValue = attrNode.getNodeValue();
                    if (attr.equalsIgnoreCase("NodeId")) {
                        nodeId = Integer.parseInt(attrValue) + 1;
                        planStep.put(attr, "" + nodeId);
                        continue;
                    }
                    planStep.put(attr, attrValue);
                    continue;
                }
                if (attr.equalsIgnoreCase("Parent")) {
                    planStep.put(attr, "" + parent);
                    continue;
                }
                planStep.put(attr, "NULL");
            }
            double totalChildCost = 0.0;
            parent = nodeId;
            for (int ni = 0; ni < nodes.getLength(); ++ni) {
                totalChildCost += this.getValueFromAttribute(nodes.item(ni).getAttributes(), "EstimatedTotalSubtreeCost");
            }
            double totalOperatorCost = this.getValueFromAttribute(attributes, "EstimatedTotalSubtreeCost") - totalChildCost;
            planStep.put("EstimatedOperatorCost", String.format("%.8f", totalOperatorCost) + " ( " + (int)(totalOperatorCost / totalCost * 100.0) + " %)");
        }
        if ((warnings = (Node)xPath.compile(LEVEL_WARNINGS_PATH).evaluate(n, XPathConstants.NODE)) != null && warnings.getChildNodes().getLength() > 0) {
            StringBuffer warnStr = new StringBuffer();
            NodeList warningSet = warnings.getChildNodes();
            for (int w = 0; w < warningSet.getLength(); ++w) {
                Node child = warningSet.item(w);
                if (child.getNodeType() != 1) continue;
                warnStr.append(warningSet.item(w).getNodeName()).append(" ;");
            }
            planStep.put("Warnings", warnStr.length() > 0 ? warnStr.toString() : "NULL");
        }
        planSteps.add(planStep);
        if (nodes.getLength() < 1) {
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node nextOp = nodes.item(i);
            this.parseOps(xPath, nextOp, attribs, totalCost, parent, planSteps);
        }
    }

    private HashMap<String, Object> initPlanStep(final List<Map<String, Object>> planSteps) {
        return new HashMap<String, Object>(){
            {
                this.put("Id", planSteps.size() + 1 + "");
            }
        };
    }
}

