/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.arf;

import com.wily.introscope.agent.arf.ArfAppException;
import com.wily.introscope.agent.arf.ArfException;
import com.wily.introscope.agent.arf.ArfLibTypeSetter;
import com.wily.introscope.agent.arf.gson.ArfAppExceptionGSON;
import com.wily.introscope.agent.arf.internal.ArfAppExceptionInternal;

public class ArfAppExceptionFactory {
    public static ArfAppException getInstance() throws Exception {
        ArfAppException exc = null;
        switch (ArfLibTypeSetter.type) {
            case INTERNAL: {
                exc = new ArfAppExceptionInternal();
                break;
            }
            case GSON: {
                exc = new ArfAppExceptionGSON();
                break;
            }
            default: {
                throw new ArfException("Incorrect Library Type Exception");
            }
        }
        return exc;
    }

    public static ArfAppException getInstance(String message) throws Exception {
        ArfAppException exc = null;
        switch (ArfLibTypeSetter.type) {
            case INTERNAL: {
                exc = new ArfAppExceptionInternal(message);
                break;
            }
            case GSON: {
                exc = new ArfAppExceptionGSON(message);
                break;
            }
            default: {
                throw new ArfException("Incorrect Library Type Exception");
            }
        }
        return exc;
    }

    public static ArfAppException getInstance(String cls, String message) throws Exception {
        ArfAppException exc = null;
        switch (ArfLibTypeSetter.type) {
            case INTERNAL: {
                exc = new ArfAppExceptionInternal(cls, message);
                break;
            }
            case GSON: {
                exc = new ArfAppExceptionGSON(cls, message);
                break;
            }
            default: {
                throw new ArfException("Incorrect Library Type Exception");
            }
        }
        return exc;
    }
}

